<?php

namespace App\Blocks;

use Log1x\AcfComposer\Block;
use StoutLogic\AcfBuilder\FieldsBuilder;

class ContentSection extends Block
{
    /**
     * The block name.
     *
     * @var string
     */
    public $name = 'Content Section';

    /**
     * The block description.
     *
     * @var string
     */
    public $description = 'A container section with customizable vertical padding.';

    /**
     * The block category.
     *
     * @var string
     */
    public $category = 'formatting';

    /**
     * The block icon.
     *
     * @var string|array
     */
    public $icon = 'text';

    /**
     * The block keywords.
     *
     * @var array
     */
    public $keywords = ['content', 'section', 'container'];

    /**
     * The block post type allow list.
     *
     * @var array
     */
    public $post_types = ['post', 'page'];

    /**
     * The default block mode.
     *
     * @var string
     */
    public $mode = 'preview';

    /**
     * The supported block features.
     *
     * @var array
     */
    public $supports = [
        'align' => true,
        'anchor' => true,
        'mode' => false,
        'multiple' => true,
        'jsx' => true,
        'innerBlocks' => true, // Enable InnerBlocks support
    ];

    /**
     * Data to be passed to the block before rendering.
     *
     * @return array
     */
    public function with()
    {
        return [
            'padding_top' => get_field('padding_top') ?: 'default',
            'padding_bottom' => get_field('padding_bottom') ?: 'default',
        ];
    }

    /**
     * The block field group.
     *
     * @return array
     */
    public function fields()
    {
        $contentSection = new FieldsBuilder('content_section');

        $contentSection
            ->setLocation('block', '==', 'acf/content-section');

        $contentSection
            ->addSelect('padding_top', [
                'label' => 'Top Padding',
                'choices' => [
                    'default' => 'Default',
                    'none' => 'None',
                ],
                'default_value' => 'default',
                'ui' => 1,
            ])
            ->addSelect('padding_bottom', [
                'label' => 'Bottom Padding',
                'choices' => [
                    'default' => 'Default',
                    'none' => 'None',
                ],
                'default_value' => 'default',
                'ui' => 1,
            ]);

        return $contentSection->build();
    }

    /**
     * Assets to be enqueued when rendering the block.
     *
     * @return void
     */
    public function enqueue()
    {
        //
    }
} 