<?php

namespace App\Fields;

use Log1x\AcfComposer\Field;
use StoutLogic\AcfBuilder\FieldsBuilder;

class Common extends Field
{
    /**
     * The field group.
     *
     * @return array
     */
    public function fields()
    {
        $fields = new FieldsBuilder('Common');

        $fields
            ->setLocation('post_type', '==', 'page');

        $fields
            ->addText('h1', [
                'instructions' => 'Specify a custom H1 to override the default setting.'
            ])
            ->addText('preheading', [
                'instructions' => 'Pre-heading goes above the H1.'
            ])
            ->addText('subtext', [
                'instructions' => 'Subtext goes beneath the H1.'
            ]);

        return $fields->build();
    }
}

add_filter( 'rank_math/frontend/breadcrumb/items', function( $crumbs, $class ) { 
 
    if(is_singular('post')){
      unset($crumbs[2]); 
      $crumbs = array_values($crumbs); 		
      return $crumbs; 	
    } 	
    return $crumbs; 
}, 10, 2);

class OTMAdminSlugColumn {

    public function __construct() {
        add_action('current_screen', array($this, 'OTM_post_type'));
        add_filter('manage_posts_columns', array($this, 'OTM_posts'));
        add_action('manage_posts_custom_column', array($this, 'OTM_posts_data'), 10, 2);
        add_filter('manage_pages_columns', array($this, 'OTM_posts'));
        add_action('manage_pages_custom_column', array($this, 'OTM_posts_data'), 10, 2);
        add_filter('manage_edit-post_sortable_columns', array($this, 'OTM_sortable_columns'));
        add_filter('manage_edit-page_sortable_columns', array($this, 'OTM_sortable_columns'));
        add_action('pre_get_posts', array($this, 'OTM_sortable_columns_orderby'));
    }

    public function OTM_post_type() {
        return get_current_screen()->post_type;
    }

    public function OTM_posts($defaults) {
        $defaults['otm-slug'] = __('URL Path', 'admin-slug-column');
        return $defaults;
    }

    public function OTM_posts_data($column_name, $id) {
        if ($column_name == 'otm-slug') {
            $post_info = get_post($id, 'string', 'display');
            $post_status = $post_info->post_status;
            $draft_slug_names = array('%pagename%', '%postname%');

            if ('draft' === $post_status || 'pending' === $post_status || 'future' === $post_status) {
                $post_draft_url_array = get_sample_permalink($id);
                $post_draft_url_pre = str_replace(get_home_url(), '', $post_draft_url_array[0]);
                $post_slug = str_replace($draft_slug_names, $post_draft_url_array[1], $post_draft_url_pre);
                $post_slug = '<span style="color: #ee7c1b;">' . $post_slug . '</span>';
            } else {
                $post_slug = str_replace(get_home_url(), '', get_permalink($id));
                $post_slug = esc_html(urldecode($post_slug));
            }

            echo $post_slug;
        }
    }

    public function OTM_sortable_columns($columns) {
        $columns['otm-slug'] = 'otm-slug';
        return $columns;
    }

    public function OTM_sortable_columns_orderby($query) {
        if (!is_admin() || !$query->is_main_query()) {
            return;
        }

        $orderby = $query->get('orderby');

        if ('otm-slug' === $orderby) {
            $query->set('orderby', 'name');
        }
    }
}

$OTMAdminSlugColumn = new OTMAdminSlugColumn();
