<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Masterminds\HTML5;

class BlocksServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        /**
         * Register blocks
         */
        add_action('init', function() {
            register_block_type('radicle/cta', [
                'render_callback' => function($attributes, $content) {
                    return view('blocks.cta', [
                        'heading' => $attributes['heading'] ?? null,
                        'description' => $attributes['description'] ?? null,
                        'image' => $attributes['image'] ?? null,
                        'block' => [
                            'attrs' => $attributes
                        ],
                    ])->render();
                },
                'attributes' => [
                    'image' => [
                        'type' => 'object',
                        'default' => null,
                    ],
                    'heading' => [
                        'type' => 'string',
                        'default' => '',
                    ],
                    'description' => [
                        'type' => 'string',
                        'default' => '',
                    ],
                    'primaryButtonText' => [
                        'type' => 'string',
                        'default' => '',
                    ],
                    'primaryButtonUrl' => [
                        'type' => 'string',
                        'default' => '#',
                    ],
                ],
            ]);
        });

        /**
         * Render `core/button` block with Blade template
         */
        add_filter('render_block', function ($block_content, $block) {
            if ($block['blockName'] === 'core/button') {
                $html5 = new HTML5();
                $dom = $html5->loadHTML($block_content);
                $classes = $dom->getElementsByTagName('a')->item(0)->getAttribute('class');
                $href = $dom->getElementsByTagName('a')->item(0)->getAttribute('href');
                $text = $dom->getElementsByTagName('a')->item(0)->textContent;
                $type = 'primary';

                if (
                    isset($block['attrs']['className']) &&
                    strpos($block['attrs']['className'], 'is-style-outline') !== false
                ) {
                    $type = 'outline';
                }

                return view('blocks.button', [
                    'type' => $type,
                    'classes' => $classes,
                    'href' => $href ?? null,
                    'text' => $text ?? null,
                ]);
            }
            return $block_content;
        }, 10, 2);

        /**
         * Render `radicle/modal` block with Blade template
         */
        add_filter('render_block', function ($block_content, $block) {
            if ($block['blockName'] === 'radicle/modal') {
                return view('blocks.modal', [
                    'block' => $block,
                    'blockContent' => $block_content,
                    'buttonText' => $block['attrs']['buttonText'] ?? null,
                    'heading' => $block['attrs']['heading'] ?? null,
                ]);
            }
            return $block_content;
        }, 10, 2);
    }
}
