<?php

namespace App;

function otm_pagination() {
    global $wp_query;
    $big = 999999999;

    $pagination_links = paginate_links([
        'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
        'format'    => '?paged=%#%',
        'current'   => max(1, get_query_var('paged')),
        'total'     => $wp_query->max_num_pages,
        'type'      => 'array',
        'prev_text' => false,
        'next_text' => false,
    ]);

    if ($pagination_links) {
        
        echo '<nav class="pagination"><ul>';
        foreach ($pagination_links as $link) {
            echo '<li>' . $link . '</li>';
        }
        echo '</ul></nav>';
    }
}