<?php
/**
 * Plugin Name: OTM FAQ Accordion
 * Description: A plugin to display custom FAQ accordions.
 * Version: 1.0
 * Author: OTM
 */

 function otm_faq_accordion_shortcode() {
    ob_start();

    if(have_rows('faq')) : ?>
        <div class="otm-faq-accordion">
            <div class="accordion">
                <?php while(have_rows('faq')) : the_row(); ?>
                    <div class="accordion-item">
                        <button class="accordion-button">
                            <h3>
                                <?php echo get_sub_field('question'); ?>
                            </h3>
                            <i><svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.29375 9.29371C3.38663 9.20061 3.49697 9.12674 3.61845 9.07634C3.73992 9.02594 3.87015 9 4.00167 9C4.13319 9 4.26342 9.02594 4.38489 9.07634C4.50637 9.12674 4.61671 9.20061 4.70959 9.29371L16.0003 20.5848L27.2909 9.29371C27.3839 9.20076 27.4943 9.12703 27.6157 9.07672C27.7372 9.02642 27.8674 9.00052 27.9989 9.00052C28.1303 9.00052 28.2605 9.02642 28.382 9.07672C28.5034 9.12703 28.6138 9.20076 28.7068 9.29371C28.7997 9.38666 28.8735 9.49701 28.9238 9.61846C28.9741 9.73991 29 9.87008 29 10.0015C29 10.133 28.9741 10.2632 28.9238 10.3846C28.8735 10.506 28.7997 10.6164 28.7068 10.7094L16.7082 22.7063C16.6153 22.7994 16.505 22.8733 16.3835 22.9237C16.262 22.9741 16.1318 23 16.0003 23C15.8687 23 15.7385 22.9741 15.617 22.9237C15.4956 22.8733 15.3852 22.7994 15.2923 22.7063L3.29375 10.7094C3.20064 10.6165 3.12676 10.5062 3.07635 10.3847C3.02595 10.2632 3 10.133 3 10.0015C3 9.87003 3.02595 9.73982 3.07635 9.61836C3.12676 9.4969 3.20064 9.38658 3.29375 9.29371Z" fill="#1C3D8D"/></svg>
                            </i>
                        </button>
                        <div class="accordion-content">
                            <?php echo get_sub_field('answer'); ?>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <?php 
        add_action('wp_footer', function() { ?>
            <script>
                (function ($) {
                    $(document).ready(function() {
                        $(".accordion-button").click(function() {
                            $(this).siblings(".accordion-content").slideToggle(300);
                            $(this).toggleClass("active");
                        });
                    });
                })(jQuery);
            </script>
        <?php }, 100); ?>

    <?php endif;

    return ob_get_clean();
}
add_shortcode('otm-faq-accordion', 'otm_faq_accordion_shortcode');