# Stream for WordPress - Security Policy

At XWP, we take the security of our software very seriously. If you believe you have found a security vulnerability in the Stream for WordPress plugin, please follow the guidelines below to report it to us. Your assistance in identifying and addressing vulnerabilities is greatly appreciated.

## Reporting a Security Vulnerability

When reporting a security vulnerability, please provide as much information as possible to help us understand and reproduce the issue. Include the following details:

1. A clear and concise description of the vulnerability, including any potential impact on users or systems.
2. Steps to reproduce the vulnerability, including any relevant screenshots or code snippets.
3. The version of the Stream for WordPress plugin where the vulnerability was discovered.
4. Any relevant information about your environment, such as the WordPress version, PHP version, and web server software.
5. Your contact information, in case we need to get in touch with you for further clarification or updates.

Please email your report to :point_right: **technology@xwp.co** :point_left: with the subject line: **Stream for WordPress - Security Vulnerability Report**.

:warning: Do not create a regular issue here on GitHub to report a vulnerability!

## Responsible Disclosure

We kindly ask that you follow the principles of responsible disclosure when reporting a security vulnerability:

1. Do NOT publicly disclose the vulnerability before giving us a reasonable amount of time to address it.
2. Do NOT use the vulnerability to access, modify, or delete unauthorized data, or disrupt the availability of the system.
3. Do NOT disclose the vulnerability to any third parties, except as necessary to coordinate with us on resolving the issue.

We commit to acknowledging receipt of your vulnerability report within 48 hours, and we will work with you to understand and address the issue as promptly as possible. Depending on the severity and complexity of the vulnerability, the resolution timeline may vary.

We greatly appreciate your assistance in helping us maintain the security and integrity of the Stream for WordPress plugin. Thank you for your cooperation and support! :blue_heart:
