"use strict";
(self["webpackChunk_roots_bud_sage_radicle"] = self["webpackChunk_roots_bud_sage_radicle"] || []).push([["main"],{

/***/ "../node_modules/@roots/bud-client/lib/hot/client.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   client: () => (/* binding */ client)
/* harmony export */ });
/* harmony import */ var _components_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/components/index.js");
/* harmony import */ var _events_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/events.js");
/* harmony import */ var _log_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/log.js");
/* harmony import */ var _options_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/options.js");
/* eslint-disable no-console */
/* global __resourceQuery */
/* global __webpack_hash__ */




/**
 * Initializes bud.js HMR handling
 */
const client = async (queryString, webpackHot) => {
    /* Guard: EventSource browser support */
    if (typeof window?.EventSource === `undefined`) {
        console.error(`[bud] hot module reload requires EventSource to work. https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events#Tools`);
        return false;
    }
    /* Guard: webpackHot api availability */
    if (!webpackHot) {
        console.error(`[bud] hot module reload requires the webpack hot api to be available`);
        return false;
    }
    /* Set client options from URL params */
    const options = _options_js__WEBPACK_IMPORTED_MODULE_3__.setFromParameters(queryString);
    /* Setup logger */
    const logger = (0,_log_js__WEBPACK_IMPORTED_MODULE_2__.makeLogger)(options);
    if (typeof window.bud === `undefined`) {
        window.bud = {
            controllers: [],
            current: {},
            hmr: {},
            listeners: {},
            reload: () => {
                window.location.reload();
            },
        };
    }
    if (!window.bud.current[options.name]) {
        window.bud.current[options.name] = null;
    }
    const isStale = (hash) => {
        if (hash)
            window.bud.current[options.name] = hash;
        return __webpack_require__.h() === window.bud.current[options.name];
    };
    /**
     * Webpack HMR check handler
     */
    const check = async () => {
        if (webpackHot.status() === `idle`) {
            await webpackHot.check(false);
            requestAnimationFrame(async function whenReady() {
                if (webpackHot.status() === `ready`) {
                    await update();
                }
                else {
                    requestAnimationFrame(whenReady);
                }
            });
        }
    };
    /**
     * Webpack HMR unaccepted module handler
     */
    const onUnacceptedOrDeclined = (info) => {
        console.warn(`[${options.name}] ${info.type}`, info);
        options.reload && window.location.reload();
    };
    /**
     * Webpack HMR error handler
     */
    const onErrored = (error) => {
        window.bud.controllers.map(controller => controller?.update({
            errors: [error],
        }));
    };
    /**
     * Webpack HMR update handler
     */
    const update = async () => {
        try {
            await webpackHot.apply({
                ignoreDeclined: true,
                ignoreErrored: true,
                ignoreUnaccepted: true,
                onDeclined: onUnacceptedOrDeclined,
                onErrored,
                onUnaccepted: onUnacceptedOrDeclined,
            });
            if (!isStale())
                await check();
        }
        catch (error) {
            logger.error(error);
        }
    };
    /* Instantiate indicator, overlay */
    try {
        await _components_index_js__WEBPACK_IMPORTED_MODULE_0__.make(options);
    }
    catch (error) { }
    /* Instantiate eventSource */
    const events = (0,_events_js__WEBPACK_IMPORTED_MODULE_1__.injectEvents)(EventSource).make(options);
    if (!window.bud.listeners?.[options.name]) {
        window.bud.listeners[options.name] = async (payload) => {
            if (!payload)
                return;
            if (options.reload && payload.action === `reload`)
                return window.bud.reload();
            if (payload.name !== options.name)
                return;
            window.bud.controllers.map(controller => controller?.update(payload));
            if (payload.errors?.length > 0)
                return;
            if (payload.action === `built` || payload.action === `sync`) {
                if (isStale(payload.hash))
                    return;
                if (payload.action === `built`) {
                    logger.log(`built in ${payload.time}ms`);
                }
                await check();
            }
        };
        /*
         * Instantiate HMR event source
         * and register client listeners
         */
        events.addListener(window.bud.listeners[options.name]);
    }
};


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/components/index.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   make: () => (/* binding */ make)
/* harmony export */ });
/* harmony import */ var _indicator_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/components/indicator/index.js");
/* harmony import */ var _overlay_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/components/overlay/index.js");


const make = async (options) => {
    if (options.indicator && !customElements.get(`bud-activity-indicator`)) {
        maybePushController(_indicator_index_js__WEBPACK_IMPORTED_MODULE_0__.make());
    }
    if (options.overlay && !customElements.get(`bud-error`)) {
        maybePushController(_overlay_index_js__WEBPACK_IMPORTED_MODULE_1__.make());
    }
    return window.bud.controllers;
};
const maybePushController = (controller) => {
    if (!controller)
        return;
    window.bud.controllers.push(controller);
};


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/components/indicator/index.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   make: () => (/* binding */ make)
/* harmony export */ });
/* harmony import */ var _indicator_component_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/components/indicator/indicator.component.js");
/* harmony import */ var _indicator_controller_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/components/indicator/indicator.controller.js");


const make = () => {
    if (customElements.get(`bud-activity-indicator`))
        return;
    customElements.define(`bud-activity-indicator`, _indicator_component_js__WEBPACK_IMPORTED_MODULE_0__.Component);
    return new _indicator_controller_js__WEBPACK_IMPORTED_MODULE_1__.Controller();
};


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/components/indicator/indicator.component.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Component: () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var _indicator_pulse_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/components/indicator/indicator.pulse.js");

/**
 * Indicator web component
 */
class Component extends HTMLElement {
    static get observedAttributes() {
        return [`has-errors`, `has-warnings`, `action`];
    }
    /**
     * Class constructor
     */
    constructor() {
        super();
        /**
         * Status indicator colors
         */
        this.colors = {
            error: [220, 38, 38, 1],
            pending: [59, 130, 246, 1],
            success: [4, 120, 87, 1],
            warn: [252, 211, 77, 1],
        };
        /**
         * Component name
         */
        this.name = `bud-activity-indicator`;
        this.renderShadow();
    }
    /**
     * Status is error
     */
    onError() {
        this.show();
        this.shadowRoot
            .querySelector(this.selector)
            .classList.remove(`warning`, `success`, `pending`);
        this.shadowRoot.querySelector(this.selector).classList.add(`error`);
    }
    /**
     * Status is pending
     */
    onPending() {
        this.show();
        this.shadowRoot
            .querySelector(this.selector)
            .classList.remove(`error`, `warning`, `success`);
        this.shadowRoot.querySelector(this.selector).classList.add(`pending`);
        this.hide();
    }
    /**
     * Status is success
     */
    onSuccess() {
        this.show();
        this.shadowRoot
            .querySelector(this.selector)
            .classList.remove(`error`, `warning`, `pending`);
        this.shadowRoot.querySelector(this.selector).classList.add(`success`);
        this.hide();
    }
    /**
     * Status is warning
     */
    onWarning() {
        this.show();
        this.shadowRoot
            .querySelector(this.selector)
            .classList.remove(`error`, `success`, `pending`);
        this.shadowRoot.querySelector(this.selector).classList.add(`warning`);
    }
    attributeChangedCallback() {
        if (this.hasAttribute(`has-errors`))
            return this.onError();
        if (this.hasAttribute(`has-warnings`))
            return this.onWarning();
        if (!this.hasAttribute(`has-errors`) &&
            !this.hasAttribute(`has-warnings`) &&
            this.getAttribute(`action`) === `built`)
            return this.onSuccess();
        if (this.getAttribute(`action`) == `building` ||
            this.getAttribute(`action`) == `sync`)
            return this.onPending();
    }
    /**
     * Get accessor: has errors
     */
    get hasErrors() {
        return this.getAttribute(`has-errors`) == `true`;
    }
    /**
     * Get accessor: has warnings
     */
    get hasWarnings() {
        return this.getAttribute(`has-warnings`) == `true`;
    }
    /**
     * Hide status indicator
     */
    hide() {
        this.hideTimeout = setTimeout(() => {
            this.shadowRoot.querySelector(this.selector).classList.remove(`show`);
        }, 2000);
    }
    /**
     * Render status indicator
     */
    renderShadow() {
        const container = document.createElement(`div`);
        container.classList.add(this.name);
        container.innerHTML = `
    <style>
    .bud-activity-indicator {
      position: fixed;
      width: 10px;
      height: 10px;
      left: 10px;
      bottom: 10px;
      z-index: 9999;
      margin: 5px;
      padding: 5px;
      -webkit-transition:
        all .6s ease-in-out,
      transition:
        all .6s ease-in-out;
      animation-fill-mode: forwards;
      pointer-events: none;
      border-radius: 50%;
      transform: scale(0);
      opacity: 0;
    }

    .show {
      opacity: 1;
      background-color: rgba(255, 255, 255, 1);
      transform: scale(1);
      transition:
        all .6s ease-in-out;
    }

    ${(0,_indicator_pulse_js__WEBPACK_IMPORTED_MODULE_0__.pulse)(`success`, this.colors.success)}
    ${(0,_indicator_pulse_js__WEBPACK_IMPORTED_MODULE_0__.pulse)(`error`, this.colors.error)}
    ${(0,_indicator_pulse_js__WEBPACK_IMPORTED_MODULE_0__.pulse)(`warning`, this.colors.warn)}
    ${(0,_indicator_pulse_js__WEBPACK_IMPORTED_MODULE_0__.pulse)(`pending`, this.colors.pending)}

    </style>
    `;
        this.attachShadow({ mode: `open` }).appendChild(container);
    }
    /**
     * Root div querySelector selector
     */
    get selector() {
        return `.${this.name}`;
    }
    /**
     * Show status indicator
     */
    show() {
        this.hideTimeout && clearTimeout(this.hideTimeout);
        this.shadowRoot.querySelector(this.selector).classList.add(`show`);
    }
}


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/components/indicator/indicator.controller.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Controller: () => (/* binding */ Controller)
/* harmony export */ });
/**
 * Activity indicator controller
 */
class Controller {
    /**
     * Initialization
     */
    constructor() {
        /**
         * Active WHM payload
         */
        this.payload = null;
        this.node = document.createElement(`bud-activity-indicator`);
        this.update = this.update.bind(this);
    }
    /**
     * Append `bud-error` element to the DOM
     */
    addNode() {
        if (document.body.querySelector(`bud-activity-indicator`)) {
            if (typeof this.timer.unref === `function`)
                this.timer.unref();
            this.removeNode();
        }
        document.body?.appendChild(this.node);
        this.timer = setTimeout(this.removeNode, 3000);
    }
    /**
     * Remove `bud-error` element from the DOM (if present)
     */
    removeNode() {
        document.body.querySelector(`bud-activity-indicator`)?.remove();
    }
    /**
     * Update activity indicator
     */
    update(payload) {
        this.node.toggleAttribute(`has-errors`, payload.errors?.length ? true : false);
        this.node.toggleAttribute(`has-warnings`, payload.warnings?.length ? true : false);
        this.node.setAttribute(`action`, payload.action);
        this.addNode();
    }
}


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/components/indicator/indicator.pulse.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   pulse: () => (/* binding */ pulse)
/* harmony export */ });
/**
 * CSS animation for reload indicator
 */
const pulse = (name, color) => `
  .${name} {
    box-shadow: 0 0 0 0 rgba(${color[0]}, ${color[1]}, ${color[2]}, ${color[3]});
    animation: ${name}__pulse 2s infinite;
    transition: all 0.4s ease-in-out;
  }

  .${name}:not(.show) {
    background-color: rgba(${color[0]}, ${color[1]}, ${color[2]}, 0);
  }

  .${name}.show {
    background-color: rgba(${color[0]}, ${color[1]}, ${color[2]}, ${color[3]});
  }

  @keyframes ${name}__pulse {
    0% {
      transform: scale(0.95);
      box-shadow: 0 0 0 0 rgba(${color[0]}, ${color[1]}, ${color[2]}, 0.7);
    }

    70% {
      transform: scale(1);
      box-shadow: 0 0 0 10px rgba(${color[0]}, ${color[1]}, ${color[2]}, 0);
    }

    100% {
      transform: scale(0.95);
      box-shadow: 0 0 0 0 rgba(${color[0]}, ${color[1]}, ${color[2]}, 0);
    }
  }
`;


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/components/overlay/index.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   make: () => (/* binding */ make)
/* harmony export */ });
/* harmony import */ var _overlay_component_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/components/overlay/overlay.component.js");
/* harmony import */ var _overlay_controller_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/components/overlay/overlay.controller.js");


const make = () => {
    if (customElements.get(`bud-error`))
        return;
    customElements.define(`bud-error`, _overlay_component_js__WEBPACK_IMPORTED_MODULE_0__.Component);
    return new _overlay_controller_js__WEBPACK_IMPORTED_MODULE_1__.Controller();
};


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/components/overlay/overlay.component.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Component: () => (/* binding */ Component)
/* harmony export */ });
/**
 * Component container
 */
class Component extends HTMLElement {
    static get observedAttributes() {
        return [`message`];
    }
    constructor() {
        super();
        this.name = `bud-overlay`;
        this.renderShadow();
    }
    attributeChangedCallback() {
        if (!this.documentBodyStyle)
            this.documentBodyStyle = document.body?.style;
        if (this.getAttribute(`message`)) {
            document.body.style.overflow = `hidden`;
            this.shadowRoot.querySelector(`.overlay`).classList.add(`visible`);
            this.shadowRoot.querySelector(`.messages`).innerHTML =
                this.getAttribute(`message`);
            return;
        }
        if (this.documentBodyStyle?.overflow && document?.body?.style) {
            document.body.style.overflow = this.documentBodyStyle.overflow;
        }
        this.shadowRoot.querySelector(`.overlay`).classList.remove(`visible`);
    }
    connectedCallback() {
        if (document.body?.style)
            this.documentBodyStyle = document.body.style;
    }
    get message() {
        return this.getAttribute(`message`);
    }
    renderShadow() {
        const container = document.createElement(`div`);
        container.classList.add(`overlay`);
        container.innerHTML = `
      <style>
        .overlay {
          width: 100vw;
          backdrop-filter: blur(10px);
          display: flex;
          height: 100vh;
          border-top: 2px solid transparent;
          overflow-x: hidden;
          overflow-y: scroll;
          position: absolute;
          top: -1000px;
          left: 0;
          right: 0;
          bottom: 0;
          opacity: 0;
          transition: opacity 0.2s ease-in-out, border 0.4s ease-in-out;
          justify-content: center;
        }

        .visible {
          position: fixed;
          top: 0;
          z-index: 9998;
          opacity: 1;
          border-top: 5px solid red;
          transition: opacity 0.2s ease-in-out, border 0.4s ease-in-out;
          max-width: 100vw;
        }

        .messages {
          background-color: white;
          border-radius: 5px;
          filter: drop-shadow(0 1px 2px rgb(0 0 0 / 0.1)) drop-shadow(0 1px 1px rgb(0 0 0 / 0.06));
          display: flex;
          align-self: center;
          width: 800px;
          max-width: 90vw;
          margin-left: auto;
          margin-right: auto;
          flex-direction: column;
          flex-wrap: wrap;
          align-items: center;
          align-content: center;
          padding: 2rem 2rem 0rem 2rem;
        }

        .visible .messages > div {
          position: relative;
          top: 0;
          opacity: 1;
          transition: all: 0.2s ease-in-out;
        }

        .messages > div {
          position: relative;
          top: 20px;
          opacity: 0;
          transition: all: 0.2s ease-in-out;
          align-items: center;
          align-content: center;
          color: rgba(0, 0, 0, 0.87);
          flex-direction: column;
          font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol";
          padding: 0rem 2rem 2rem 2rem;
          width: 100%;
          max-width:95vw;
        }

        .messages > div > pre {
          font-weight: 300;
          font-size: 0.8rem;
          overflow-x: scroll;
        }

        pre {
          background: #303030;
          color: #f1f1f1;
          padding: 10px 16px;
          border-radius: 2px;
          border-top: 4px solid #dd0303;
          -moz-box-shadow: inset 0 0 10px #000;
          box-shadow: inset 0 0 10px #000;
          counter-reset: line;
        }

        pre span {
          display: block;
          line-height: 1.5rem;
        }

        pre span:before {
          counter-increment: line;
          content: counter(line);
          display: inline-block;
          border-right: 1px solid #ddd;
          padding: 0 .5em;
          margin-right: .5em;
          color: #888;
          width: 30px;
        }
      </style>
      <div class="messages"></div>
    `;
        this.attachShadow({ mode: `open` }).appendChild(container);
    }
}


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/components/overlay/overlay.controller.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Controller: () => (/* binding */ Controller)
/* harmony export */ });
const ansiPattern = [
    `[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)`,
    `(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))`,
].join(`|`);
const stripAnsi = (body) => body?.replace?.(new RegExp(ansiPattern, `g`), ``) ?? body;
/**
 * Overlay controller
 */
class Controller {
    /**
     * Class constructor
     */
    constructor() {
        this.update = this.update.bind(this);
        this.element = document.createElement(`bud-error`);
    }
    /**
     * Append `bud-error` element to the DOM
     */
    createError() {
        !document.body.querySelector(`bud-error`) &&
            document.body?.appendChild(this.element);
    }
    /**
     * Formatted error message
     */
    get message() {
        return this.payload.errors?.reduce((a, c) => {
            const msg = c?.message ?? c?.error ?? c;
            if (!msg)
                return a;
            return `${a}
        <div>
          <pre>${stripAnsi(msg)}</pre>
        </div>`;
        }, ``);
    }
    /**
     * Remove `bud-error` element from the DOM (if present)
     */
    removeError() {
        document.body.querySelector(`bud-error`)?.remove();
    }
    /**
     * Update DOM
     */
    update(payload) {
        this.payload = payload;
        this.element.setAttribute(`message`, this.message ?? ``);
        if (this.payload.errors?.length > 0) {
            return this.createError();
        }
        this.removeError();
    }
}


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/events.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   injectEvents: () => (/* binding */ injectEvents)
/* harmony export */ });
const injectEvents = (eventSource) => {
    /**
     * EventSource wrapper
     *
     * @remarks
     * wraps EventSource in a function to allow for
     * mocking in tests
     */
    return class Events extends eventSource {
        /**
         * Singleton constructor
         *
         */
        static make(options) {
            if (typeof window.bud.hmr[options.name] === `undefined`)
                Object.assign(window.bud.hmr, {
                    [options.name]: new Events(options),
                });
            return window.bud.hmr[options.name];
        }
        /**
         * Class constructor
         *
         * @remarks
         * Singleton interface, so this is private.
         *
         */
        constructor(options) {
            super(options.path);
            this.options = options;
            /**
             * Registered listeners
             */
            this.listeners = new Set();
            /**
             * EventSource `onmessage` handler
             */
            this.onmessage = async function (payload) {
                if (!payload?.data || payload.data == `\uD83D\uDC93`) {
                    return;
                }
                try {
                    const data = JSON.parse(payload.data);
                    if (!data)
                        return;
                    await Promise.all([...this.listeners].map(async (listener) => {
                        return await listener(data);
                    }));
                }
                catch (ex) { }
            };
            /**
             * EventSource `onopen` handler
             */
            this.onopen = function () { };
            this.onopen = this.onopen.bind(this);
            this.onmessage = this.onmessage.bind(this);
            this.addListener = this.addListener.bind(this);
        }
        /**
         * EventSource `addMessageListener` handler
         */
        addListener(listener) {
            this.listeners.add(listener);
            return this;
        }
    };
};


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/index.js?indicator=true&name=radicle&overlay=true&reload=true":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

var __resourceQuery = "?indicator=true&name=radicle&overlay=true&reload=true";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _client_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../node_modules/@roots/bud-client/lib/hot/client.js");
/* eslint-disable no-console */
/* global __resourceQuery */
/* global module */

(async function () {
    try {
        await (0,_client_js__WEBPACK_IMPORTED_MODULE_0__.client)(__resourceQuery, __webpack_module__.hot);
    }
    catch (err) {
        console.error(err);
    }
})();


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/log.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeError: () => (/* binding */ makeError),
/* harmony export */   makeInfo: () => (/* binding */ makeInfo),
/* harmony export */   makeLog: () => (/* binding */ makeLog),
/* harmony export */   makeLogger: () => (/* binding */ makeLogger),
/* harmony export */   makeWarn: () => (/* binding */ makeWarn)
/* harmony export */ });
/* eslint-disable no-console */
const makeLogger = (options) => {
    return {
        error: makeError(options),
        info: makeInfo(options),
        log: makeLog(options),
        warn: makeWarn(options),
    };
};
const makeLog = (options) => {
    return (...args) => {
        if (options.log) {
            console.log(`[${options.name}]`, ...args);
        }
    };
};
const makeInfo = (options) => {
    return (...args) => {
        if (options.log) {
            console.info(`[${options.name}]`, ...args);
        }
    };
};
const makeError = (options) => {
    return (...args) => {
        console.error(`[${options.name}]`, ...args);
    };
};
const makeWarn = (options) => {
    return (...args) => {
        console.warn(`[${options.name}]`, ...args);
    };
};


/***/ }),

/***/ "../node_modules/@roots/bud-client/lib/hot/options.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   data: () => (/* binding */ data),
/* harmony export */   get: () => (/* binding */ get),
/* harmony export */   setFromParameters: () => (/* binding */ setFromParameters)
/* harmony export */ });
/**
 * Client options
 */
let data = {
    debug: true,
    indicator: true,
    log: true,
    name: `@roots/bud-client`,
    overlay: true,
    path: `/bud/hot`,
    reload: true,
    timeout: 2000,
};
/**
 * Get client option
 */
const get = (name, key) => key ? data[name][key] : data[name];
/**
 * Set client data based on URL parameters
 */
const setFromParameters = (query) => {
    let parsedParams = {};
    new window.URLSearchParams(query).forEach((value, key) => {
        parsedParams[key] =
            value === `true` ? true : value === `false` ? false : value;
    });
    data[parsedParams.name] = { ...data, ...parsedParams };
    return data[parsedParams.name];
};



/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ var __webpack_exports__ = (__webpack_exec__("../node_modules/@roots/bud-client/lib/hot/index.js?indicator=true&name=radicle&overlay=true&reload=true"));
/******/ }
]);
//# sourceMappingURL=main.js.map