@php
    $isOpen = filter_var($open ?? false, FILTER_VALIDATE_BOOLEAN);
    $questionContent = isset($question) ? trim((string) $question) : ($attributes->get('question') ?? 'Frequently Asked Question');
    $answerContent = isset($answer) ? (string) $answer : (string) ($slot ?? $attributes->get('answer', ''));
    $componentId = $attributes->get('id') ?? 'faq-' . (string) \Illuminate\Support\Str::uuid();
@endphp

<div
    x-data="{ open: {{ $isOpen ? 'true' : 'false' }} }"
    x-id="['answer']"
    {{ $attributes->merge(['class' => 'faq-alt-component']) }}
>
    <button
        type="button"
        @click="open = !open"
        :aria-expanded="open"
        aria-controls="{{ $componentId }}"
        class="w-full flex items-center justify-between gap-4 py-3 focus:outline-none border-t border-gray-200"
    >
        <x-icon-info class="mt-0.5" />
        <span class="font-medium w-full text-left">{{ $questionContent }}</span>
        <svg
            class="w-5 h-5 text-gray-500 transition-transform duration-300"
            :class="{ 'rotate-180': open }"
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
        >
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <div
        id="{{ $componentId }}"
        x-ref="content"
        x-effect="$el.style.maxHeight = open ? $el.scrollHeight + 'px' : '0px'"
        class="overflow-hidden transition-all duration-300 ease-in-out"
    >
        <div class="px-8 pb-4 pt-0 text-gray-600 text-sm leading-relaxed">
            {{ $answerContent }}
        </div>
    </div>
</div>

