@php
$types = [
    'primary' => 'logo',
    'secondary' => 'logo_secondary',
    'mobile' => 'logo_mobile',
];

$logo = get_field('branding', 'option')[$types[$attributes->get('type', 'primary')]];
$logoWebp = get_field('branding', 'option')[$types[$attributes->get('type', 'primary')] . '_webp'];
$logoExt = pathinfo($logo['url'], PATHINFO_EXTENSION);
@endphp

@if($logo)
    <a href="{{ home_url('/') }}" class="{{ $attributes->get('class') }}" title="{!! $siteName !!}">
        <picture>
            @if($logoWebp)
                <source srcset="{{ $logoWebp['url'] }}" type="image/webp">
            @endif
            <source srcset="{{ $logo['url'] }}" type="image/{{ $logoExt }}">
            <img src=" {{$logo['url']}} " alt="@php(bloginfo('name'))" title="@php(bloginfo('name'))">
        </picture>
    </a>
@endif
