<div x-data="{ isOpen: false }" class="read-more-component">
    <div
        x-ref="content"
        class="relative overflow-hidden transition-all duration-500"
        :style="isOpen ? 'max-height: ' + $refs.content.scrollHeight + 'px' : 'max-height: 0px'"
    >
        {{ $slot }}
    </div>

    <button 
        @click="isOpen = !isOpen"
        class="mt-2 hover:text-orange-600 font-semibold focus:outline-none transition-all outline-none"
    >
        <span x-text="isOpen ? 'Read Less' : 'Read More'"></span>
        <svg 
            class="inline-block ml-1 w-4 h-4 transition-transform duration-300"
            :class="{ '-scale-y-100': isOpen }"
            xmlns="http://www.w3.org/2000/svg" 
            fill="none" 
            viewBox="0 0 24 24" 
            stroke="currentColor"
        >
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>
</div>