@props([
    'title' => '',
    'description' => '',
    'imgSrc' => '',
    'href' => '#',
    'tag' => 'h3',
])

@php
    $tag = in_array($tag, ['p', 'h2', 'h3', 'h4']) ? $tag : 'h3';
@endphp

<a href="{{ $href }}" {{ $attributes->merge(['class' => 'card']) }} title="{{ $title }}">
    <img src="{{ $imgSrc }}" alt="{{ $title }}" title="{{ $title }}" class="mb-4">
    <{{ $tag }} class="text-xl font-bold mb-3.75 [font-size:30px] [line-height:130%] font-satoshi">{{ $title }}</{{ $tag }}>
    <p>{!! $description !!}</p>
    <i class="inline-block">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
            <path d="M13.5 4.5L21 12M21 12L13.5 19.5M21 12H3" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
    </i>
</a>