@props([
    'count',
    'bordered',
])

@hasoptions('social_profiles')
    <div class="flex flex-wrap gap-5 max-sm:justify-center {{ $attributes->get('class') }}">
        @options('social_profiles')
            @php $iteration = 1; @endphp
            @options('social_profile')
                @if (!isset($count) || $iteration <= $count)
                    <a class="flex items-center justify-center h-12 w-12 border-2 border-orange-600 hover:text-white hover:bg-orange-600 rounded-2xl transition-all" href="@sub('social_profile_url')" target="_blank" rel="nofollow noreferrer noopener" title="{{ 'Find Us On' }} @sub('social_profile_name')">
                        @sub('svg_code')
                    </a>
                @endif
                @php $iteration++; @endphp
            @endoptions
        @endoptions
    </div>
@endhasoptions