@extends('layouts.app')

@section('content')
    <section class="pt-10 lg:pt-20 pb-16 lg:pb-36">
        <div class="container grid lg:grid-cols-2 items-center gap-8">
            <div>
                <p class="subheading mb-3">Blog</p>
                <h1 class="h2 mb-6">Latest Blog Posts</h1>
                <p>We've gathered everything you need for <a href="/services/hawaii-car-shipping/" class="underline underline-offset-2">shipping a car to and from Hawaii</a> – from resources and documents to important tips. Make your planning easy and feel more confident about shipping your car by checking out the helpful information on this page.</p>
                @if (function_exists('rank_math_the_breadcrumbs'))
                    <div class="mt-6 lg:mt-12">
                        @php rank_math_the_breadcrumbs(); @endphp
                    </div>
                @endif
            </div>
            <div class="hidden lg:grid grid-cols-2 gap-10 xl:gap-x-16 border-2 border-blue-50 rounded-[32px] p-10 xl:p-16">
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">20 Years</span> of Shipping Experience</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">Fully Insured</span> Transportation</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">24/7</span> Customer Support</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">136k+</span> Satisfied Customers</p>
            </div>
        </div>
    </section>
    @include('partials.post-card')
    @include('sections.quote-cta')
@endsection