<!doctype html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="theme-color" content="#F0EEE3" media="(prefers-color-scheme: light)">
        <meta name="theme-color" content="#555247" media="(prefers-color-scheme: dark)">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&family=M+PLUS+1:wght@100..900&display=swap" rel="stylesheet">
        
        <?php wp_head(); ?>
        @include('utils.styles')
    </head>

    <body <?php body_class('px-0 overflow-x-hidden'); ?>>
        <?php wp_body_open(); ?>
        <?php do_action('get_header'); ?>
        <div id="app">

            @include('sections.header')

            @yield('before-content')

            <div class="{{ $containerInnerClasses }} @hasSection('sidebar') gap-6 lg:grid-cols-12 grid @endif">
                <main id="main" class="@hasSection('sidebar')lg:col-span-8 @endif">
                    <div>
                        @yield('content')
                    </div>
                </main>

                @hasSection('sidebar')
                    <aside class="sidebar lg:col-span-4">
                        @yield('sidebar')
                    </aside>
                @endif
            </div>

            @yield('after-content')

            @include('sections.footer')
        </div>
        <?php do_action('get_footer'); ?>
        @stack('after-scripts')
        <?php wp_footer(); ?>
        @include('utils.scripts')
    </body>
</html>