{{--
	Template Name: Resources
--}}

@extends('layouts.app')

@section('content')
    <section class="pt-10 lg:pt-20 pb-16 lg:pb-36">
        <div class="container grid lg:grid-cols-2 items-center gap-8">
            <div>
                <p class="subheading mb-3">Resources</p>
                <h1 class="h2 mb-6">{!! $heading !!}</h1>
                <div class="text-content">
                    @content
                </div>
                @if (function_exists('rank_math_the_breadcrumbs'))
                    <div class="mt-6 lg:mt-12">
                        @php rank_math_the_breadcrumbs(); @endphp
                    </div>
                @endif
            </div>
            <div class="hidden lg:grid grid-cols-2 gap-10 xl:gap-x-16 border-2 border-blue-50 rounded-[32px] p-10 xl:p-16">
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">20 Years</span> of Shipping Experience</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">Fully Insured</span> Transportation</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">24/7</span> Customer Support</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">136k+</span> Satisfied Customers</p>
            </div>
        </div>
    </section>
    @hasfields('resources')
        <section>
            <div class="container grid md:grid-cols-2 lg:grid-cols-3 gap-3 lg:gap-8">
                @fields('resources')
                    <div class="relative p-6 lg:p-11 !pb-23 lg:!pb-28 border-2 border-blue-50 rounded-[32px]">
                        @if(get_sub_field('icon'))
                            <i class="bg-blue-50 rounded-xl h-12 w-12 flex items-center justify-center mb-5">@sub('icon')</i>
                        @else
                            <i class="bg-blue-50 rounded-xl h-12 w-12 flex items-center justify-center mb-5"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path d="M21.375 11.9999C21.375 12.2983 21.2564 12.5844 21.0455 12.7954C20.8345 13.0064 20.5483 13.1249 20.25 13.1249H12C11.7016 13.1249 11.4154 13.0064 11.2045 12.7954C10.9935 12.5844 10.875 12.2983 10.875 11.9999C10.875 11.7016 10.9935 11.4154 11.2045 11.2044C11.4154 10.9934 11.7016 10.8749 12 10.8749H20.25C20.5483 10.8749 20.8345 10.9934 21.0455 11.2044C21.2564 11.4154 21.375 11.7016 21.375 11.9999ZM12 7.12492H20.25C20.5483 7.12492 20.8345 7.00639 21.0455 6.79542C21.2564 6.58444 21.375 6.29829 21.375 5.99992C21.375 5.70155 21.2564 5.4154 21.0455 5.20442C20.8345 4.99345 20.5483 4.87492 20.25 4.87492H12C11.7016 4.87492 11.4154 4.99345 11.2045 5.20442C10.9935 5.4154 10.875 5.70155 10.875 5.99992C10.875 6.29829 10.9935 6.58444 11.2045 6.79542C11.4154 7.00639 11.7016 7.12492 12 7.12492ZM20.25 16.8749H12C11.7016 16.8749 11.4154 16.9934 11.2045 17.2044C10.9935 17.4154 10.875 17.7016 10.875 17.9999C10.875 18.2983 10.9935 18.5844 11.2045 18.7954C11.4154 19.0064 11.7016 19.1249 12 19.1249H20.25C20.5483 19.1249 20.8345 19.0064 21.0455 18.7954C21.2564 18.5844 21.375 18.2983 21.375 17.9999C21.375 17.7016 21.2564 17.4154 21.0455 17.2044C20.8345 16.9934 20.5483 16.8749 20.25 16.8749ZM7.45402 3.70398L5.24996 5.90617L4.5459 5.20117C4.33455 4.98983 4.04791 4.87109 3.74902 4.87109C3.45014 4.87109 3.16349 4.98983 2.95215 5.20117C2.7408 5.41251 2.62207 5.69916 2.62207 5.99804C2.62207 6.29693 2.7408 6.58358 2.95215 6.79492L4.45215 8.29492C4.55666 8.3998 4.68086 8.48302 4.8176 8.5398C4.95435 8.59658 5.10096 8.62581 5.24902 8.62581C5.39709 8.62581 5.5437 8.59658 5.68044 8.5398C5.81719 8.48302 5.94138 8.3998 6.0459 8.29492L9.0459 5.29492C9.25724 5.08358 9.37597 4.79693 9.37597 4.49804C9.37597 4.19916 9.25724 3.91251 9.0459 3.70117C8.83455 3.48983 8.54791 3.37109 8.24902 3.37109C7.95014 3.37109 7.66349 3.48983 7.45215 3.70117L7.45402 3.70398ZM7.45402 9.70398L5.24996 11.9062L4.5459 11.2012C4.33455 10.9898 4.04791 10.8711 3.74902 10.8711C3.45014 10.8711 3.16349 10.9898 2.95215 11.2012C2.7408 11.4125 2.62207 11.6992 2.62207 11.998C2.62207 12.2969 2.7408 12.5836 2.95215 12.7949L4.45215 14.2949C4.55666 14.3998 4.68086 14.483 4.8176 14.5398C4.95435 14.5966 5.10096 14.6258 5.24902 14.6258C5.39709 14.6258 5.5437 14.5966 5.68044 14.5398C5.81719 14.483 5.94138 14.3998 6.0459 14.2949L9.0459 11.2949C9.25724 11.0836 9.37597 10.7969 9.37597 10.498C9.37597 10.1992 9.25724 9.91251 9.0459 9.70117C8.83455 9.48983 8.54791 9.37109 8.24902 9.37109C7.95014 9.37109 7.66349 9.48983 7.45215 9.70117L7.45402 9.70398ZM7.45402 15.704L5.24996 17.9062L4.5459 17.2012C4.44125 17.0965 4.31702 17.0135 4.18029 16.9569C4.04356 16.9002 3.89702 16.8711 3.74902 16.8711C3.60103 16.8711 3.45448 16.9002 3.31776 16.9569C3.18103 17.0135 3.05679 17.0965 2.95215 17.2012C2.8475 17.3058 2.76449 17.4301 2.70785 17.5668C2.65122 17.7035 2.62207 17.8501 2.62207 17.998C2.62207 18.146 2.65122 18.2926 2.70785 18.4293C2.76449 18.566 2.8475 18.6903 2.95215 18.7949L4.45215 20.2949C4.55666 20.3998 4.68086 20.483 4.8176 20.5398C4.95435 20.5966 5.10096 20.6258 5.24902 20.6258C5.39709 20.6258 5.5437 20.5966 5.68044 20.5398C5.81719 20.483 5.94138 20.3998 6.0459 20.2949L9.0459 17.2949C9.25724 17.0836 9.37597 16.7969 9.37597 16.498C9.37597 16.1992 9.25724 15.9125 9.0459 15.7012C8.83455 15.4898 8.54791 15.3711 8.24902 15.3711C7.95014 15.3711 7.66349 15.4898 7.45215 15.7012L7.45402 15.704Z" fill="#4668C4"/>
                              </svg></i>
                        @endif
                        @hassub('title')
                            <p class="h4 mb-4">@sub('title')</p>
                        @endsub
                        @hassub('description')
                            <p>@sub('description')</p>
                        @endsub
                        @if(get_sub_field('download_link'))
                            <x-button type="primary" href="{{ get_sub_field('download_link') }}" class="absolute inline-block bottom-6 lg:bottom-11 left-6 lg:left-11" target="_blank" title="Download File">Download File</x-button>
                        @endif
                    </div>
                @endfields
            </div>
        </section>
    @endhasfields
@endsection