<article @php(post_class())>
    <a href="{{ get_permalink() }}" class="post-card block">
        @if (has_post_thumbnail())
            <div class="post-thumbnail relative">
                @if (wp_is_mobile())
                    {!! get_the_post_thumbnail(null, 'medium', ['class' => 'img-fluid']) !!}
                @else
                    {!! get_the_post_thumbnail(null, 'large', ['class' => 'img-fluid']) !!}
                @endif
                <div class="arrow opacity-0">
                    <span>Read Article</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M8.25 4.5L15.75 12L8.25 19.5" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </div>
        @else
            <div class="post-thumbnail relative">
                <img src="@asset('images/backgrounds/blog-placeholder.svg')" alt="Image Placeholder" loading="lazy">
                <div class="arrow opacity-0">
                    <span>Read Article</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M8.25 4.5L15.75 12L8.25 19.5" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </div>
        @endif
        <div class="card-body">
            @include('partials.entry-meta')
            <h2 class="entry-title h5 mb-5">
                    {!! $title !!}            
            </h2>
            <div class="entry-summary">
                @php(the_excerpt())
            </div>
        </div>
    </a>
</article>