<div class="lg:hidden">
    <h2 class="text-center text-white">Let&rsquo;s Talk About Your Case</h2>
    <p class="text-center text-lgrey">We will help you!</p>
    <div class="mx-auto h-0.75 w-25 bg-bgreen mt-3.75 mb-7.5"></div>
</div>
<form class="otm-form horizontal">
    <div class="grid gap-3.75 md:gap-7.5">
        <div class="input-wrapper">
            <label class="block font-bold text-white mb-1.5" for="first-name">First Name</label>
            <input class="form-control" id="first-name" type="text" name="from" placeholder="Enter your first name" required>
        </div>
        <div class="input-wrapper">
            <label class="block font-bold text-white mb-1.5" for="last-name">Last Name</label>
            <input class="form-control" id="last-name" type="text" name="last-name" placeholder="Enter your last name" required>
        </div>
        <div class="input-wrapper">
            <label class="block font-bold text-white mb-1.5" for="email">Email Address</label>
            <input class="form-control" id="email" type="email" name="sender" placeholder="Enter your email" required>
        </div>
        <div class="input-wrapper">
            <label class="block font-bold text-white mb-1.5" for="phone-number">Phone</label>
            <input class="form-control" id="phone-number" type="text" name="phone" placeholder="Enter your phone number" required>
        </div>
        <div class="input-wrapper">
            <label class="block font-bold text-white mb-1.5" for="city">City</label>
            <input class="form-control" id="city" type="text" name="city" placeholder="Enter your city" required>
        </div>
        <div class="input-wrapper">
            <label class="block font-bold text-white mb-1.5" for="state">State</label>
            <input class="form-control" id="state" type="text" name="state" placeholder="Enter your state" required>
        </div>
        <div class="input-wrapper">
            <label class="block font-bold text-white mb-1.5" for="message">Tell Us About Your Legal Situation</label>
            <textarea class="form-control !h-25" id="message" placeholder="Describe your legal situation" name="msg" required></textarea>
        </div>
    </div>
    <input class="hidden" name="your-url" type="text" tabindex="-1" autocomplete="off" />
    <button class="btn1 !w-fit mx-auto mt-7.5 lg:mt-10" type="submit" title="Click to Send Message">Send Message</button>
    <div class="form-response-success [background:#effdf4] [color:#166534] p-2.5 mt-5 hidden text-center" role="alert">
        Your message has been successfully sent. Looking forward to speaking with you soon.
    </div>
    <div class="form-response-error [background:#fef2f2] [color:#991b1b] p-2.5 mt-5 hidden text-center" role="alert">
        Your message has not been sent. Please try again later.
    </div>
</form>

<script>
    document.getElementById('phone-number').addEventListener('input', function (e) {
        let input = e.target.value;
        input = input.replace(/\D/g, '');
        if (input.length > 0) {
            if (input.length <= 3) {
                input = '(' + input;
            } else if (input.length <= 6) {
                input = '(' + input.slice(0, 3) + ') ' + input.slice(3);
            } else if (input.length <= 10) {
                input = '(' + input.slice(0, 3) + ') ' + input.slice(3, 6) + '-' + input.slice(6);
            } else {
                input = '(' + input.slice(0, 3) + ') ' + input.slice(3, 6) + '-' + input.slice(6, 10);
            }
        }
        e.target.value = input;
    });
</script>