<form class="otm-form vertical grid gap-3.75">
    <input class="form-control" type="text" name="from" placeholder="Full Name" required>
    <input class="form-control" type="email" name="sender" placeholder="Email" required>
    <input class="form-control" type="text" id="phone" name="phone" placeholder="Phone" required>
    <textarea class="form-control" placeholder="Your Message" name="msg" required></textarea>
    <input class="hidden" name="your-url" type="text" tabindex="-1" autocomplete="off" />
    <button class="btn2 !w-full" type="submit" title="Click to Send Message">Send Information</button>
    <div class="form-response-success [background:#effdf4] [color:#166534] p-2.5 hidden text-center" role="alert">
        Your message has been successfully sent. Looking forward to speaking with you soon.
    </div>
    <div class="form-response-error [background:#fef2f2] [color:#991b1b] p-2.5 hidden text-center" role="alert">
        Your message has not been sent. Please try again later.
    </div>
</form>
<script>
    document.getElementById('phone').addEventListener('input', function (e) {
        let input = e.target.value;
        input = input.replace(/\D/g, '');
        if (input.length > 0) {
            if (input.length <= 3) {
                input = '(' + input;
            } else if (input.length <= 6) {
                input = '(' + input.slice(0, 3) + ') ' + input.slice(3);
            } else if (input.length <= 10) {
                input = '(' + input.slice(0, 3) + ') ' + input.slice(3, 6) + '-' + input.slice(6);
            } else {
                input = '(' + input.slice(0, 3) + ') ' + input.slice(3, 6) + '-' + input.slice(6, 10);
            }
        }
        e.target.value = input;
    });
</script>