@if(is_page_template('page-services.blade.php'))
    <section class="pt-10 lg:pt-20 pb-16 lg:pb-36">
        <div class="container grid lg:grid-cols-[1fr_420px] items-center justify-between gap-8">
            <div class="lg:max-w-[600px]">
                <p class="subheading mb-3">Services</p>
                <h1 class="h2 mb-6">{!! $heading !!}</h1>
                <div class="text-lg font-medium">{!! get_field('subtext') !!}</div>
                @if (function_exists('rank_math_the_breadcrumbs'))
                    <div class="mt-6 lg:mt-12">
                        @php rank_math_the_breadcrumbs(); @endphp
                    </div>
                @endif
            </div>
            <div>
                <p class="h3 mb-5">Get A <span class="whitespace-nowrap text-orange-600 pb-2 relative after:content-[''] after:absolute after:h-2 after:w-full after:bg-underline after:bottom-0 after:left-0 after:bg-no-repeat after:bg-center after:bg-contain">Free Instant Quote</span></p>
                @include('partials.multistep-form.form')
            </div>
        </div>
    </section>
@elseif(wp_get_post_parent_id( get_the_ID() ) == 256) {{-- Service Pages --}}
    <section class="pt-10 lg:pt-20 pb-16 lg:pb-36">
        <div class="container grid lg:grid-cols-[1fr_420px] items-center justify-between gap-8">
            <div class="lg:max-w-[600px]">
                @if(get_field('preheading'))
                    <p class="subheading mb-3">{!! get_field('preheading') !!}</p>
                @else
                    <p class="subheading mb-3">@title</p>
                @endif
                <h1 class="h2 mb-6">{!! $heading !!}</h1>
                @if(get_field('hero_description'))
                    <div class="text-content">@field('hero_description')</div>
                @elseif(get_field('subtext'))
                    <div class="text-lg font-medium">{!! get_field('subtext') !!}</div>
                @endif
                @if (function_exists('rank_math_the_breadcrumbs'))
                    <div class="mt-6 lg:mt-12">
                        @php rank_math_the_breadcrumbs(); @endphp
                    </div>
                @endif
            </div>
            <div>
                <p class="h3 mb-5">Get A <span class="whitespace-nowrap text-orange-600 pb-2 relative after:content-[''] after:absolute after:h-2 after:w-full after:bg-underline after:bottom-0 after:left-0 after:bg-no-repeat after:bg-center after:bg-contain">Free Instant Quote</span></p>
                @include('partials.multistep-form.form')
            </div>
        </div>
    </section>
@elseif(is_page_template('page-who-we-are.blade.php'))
    <section class="pt-10 lg:pt-20 pb-16 lg:pb-36">
        <div class="container grid lg:grid-cols-2 items-center gap-8">
            <div class="lg:max-w-[600px]">
                <p class="subheading mb-3">Who We Are</p>
                <h1 class="h2 mb-6">{!! $heading !!}</h1>
                <div class="text-lg font-medium">{!! get_field('subtext') !!}</div>
                @if (function_exists('rank_math_the_breadcrumbs'))
                    <div class="mt-6 lg:mt-12">
                        @php rank_math_the_breadcrumbs(); @endphp
                    </div>
                @endif
            </div>
            <div class="grid grid-cols-2 gap-10 xl:gap-x-16 border-2 border-blue-50 rounded-[32px] p-10 xl:p-16">
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">20 Years</span> of Shipping Experience</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">Fully Insured</span> Transportation</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">24/7</span> Customer Support</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">136k+</span> Satisfied Customers</p>
            </div>
        </div>
    </section>
@else
    <section class="pt-10 lg:pt-20 pb-16 lg:pb-36">
        <div class="container grid lg:grid-cols-2 items-center gap-8">
            <div class="lg:max-w-[600px]">
                @if(get_field('preheading'))
                    <p class="subheading mb-3">{!! get_field('preheading') !!}</p>
                @endif
                <h1 class="h2 mb-6">{!! $heading !!}</h1>
                <div class="text-lg font-medium">{!! get_field('subtext') !!}</div>
                @if (function_exists('rank_math_the_breadcrumbs'))
                    <div class="mt-6 lg:mt-12">
                        @php rank_math_the_breadcrumbs(); @endphp
                    </div>
                @endif
            </div>
            <div class="grid grid-cols-2 gap-10 xl:gap-x-16 border-2 border-blue-50 rounded-[32px] p-10 xl:p-16">
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">20 Years</span> of Shipping Experience</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">Fully Insured</span> Transportation</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">24/7</span> Customer Support</p>
                <p><span class="block text-blue-600 font-extrabold font-mplus text-2xl mb-2">136k+</span> Satisfied Customers</p>
            </div>
        </div>
    </section>
@endif