<form x-data="transportForm()">
  <!-- Transport From Section -->
  <div>
      <label class="block font-medium mb-1.5">Transport From</label>
      
      <!-- Toggle Buttons -->
      <div class="flex w-fit rounded-full border border-gray-300 p-1 mb-4">
          <button 
              type="button"
              @click="transportFrom = 'city'"
              :class="transportFrom === 'city' 
                  ? 'bg-orange-600 text-white' 
                  : 'bg-white text-gray-700 border border-transparent'"
              class="px-4 py-2 rounded-full font-medium transition-colors duration-200"
          >
              City / ZIP
          </button>
          <button 
              type="button"
              @click="transportFrom = 'port'"
              :class="transportFrom === 'port' 
                  ? 'bg-orange-600 text-white' 
                  : 'bg-white text-gray-700 border border-transparent'"
              class="px-4 py-2 rounded-full font-medium transition-colors duration-200"
          >
              Port
          </button>
      </div>
      
      <div class="h-16 relative">
          <!-- City/ZIP Input Field -->
          <div 
              x-show="transportFrom === 'city'" 
              x-transition:enter="transition ease-out duration-300"
              x-transition:enter-start="opacity-0 transform translate-y-2"
              x-transition:enter-end="opacity-100 transform translate-y-0"
              x-transition:leave="transition ease-in duration-200"
              x-transition:leave-start="opacity-100 transform translate-y-0"
              x-transition:leave-end="opacity-0 transform -translate-y-2"
              class="absolute inset-0"
          >
              <input 
                  type="text" 
                  placeholder="e.g., Los Angeles, 90001"
                  class="w-full px-4 py-3 rounded-2xl bg-gray-50 border border-gray-200 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent placeholder-gray-400"
              >
          </div>
          
          <!-- Port Dropdown Field -->
          <div 
              x-show="transportFrom === 'port'" 
              x-transition:enter="transition ease-out duration-300"
              x-transition:enter-start="opacity-0 transform translate-y-2"
              x-transition:enter-end="opacity-100 transform translate-y-0"
              x-transition:leave="transition ease-in duration-200"
              x-transition:leave-start="opacity-100 transform translate-y-0"
              x-transition:leave-end="opacity-0 transform -translate-y-2"
              class="absolute inset-0"
          >
              <div class="relative">
                  <select 
                      class="w-full px-4 py-3 rounded-2xl bg-gray-50 border border-gray-200 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent appearance-none cursor-pointer"
                  >
                      <option value="" disabled selected>Please select a port</option>
                      <option value="honolulu-hi">Honolulu, HI</option>
                      <option value="hilo-hi">Hilo, HI</option>
                      <option value="nawiliwili-hi">Nawiliwili, HI</option>
                      <option value="kahului-hi">Kahului, HI</option>
                      <option value="san-juan-pr">San Juan, PR</option>
                      <option value="long-beach-ca">Long Beach, CA</option>
                      <option value="oakland-ca">Oakland, CA</option>
                      <option value="tacoma-wa">Tacoma, WA</option>
                      <option value="jacksonville-fl">Jacksonville, FL</option>
                      <option value="eddystone-pa">Eddystone, PA</option>
                  </select>
                  <!-- Custom Chevron Icon -->
                  <div class="absolute right-4 top-1/2 transform -translate-y-1/2 pointer-events-none">
                      <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                      </svg>
                  </div>
              </div>
          </div>
      </div>
  </div>

  <!-- Transport To Section -->
  <div class="mb-5">
      <label class="block font-medium mb-1.5">Transport To</label>
      
      <!-- Toggle Buttons -->
      <div class="flex w-fit rounded-full border border-gray-300 p-1 mb-4">
          <button 
              type="button"
              @click="transportTo = 'city'"
              :class="transportTo === 'city' 
                  ? 'bg-orange-600 text-white' 
                  : 'bg-white text-gray-700 border border-transparent'"
              class="px-4 py-2 rounded-full font-medium transition-colors duration-200"
          >
              City / ZIP
          </button>
          <button 
              type="button"
              @click="transportTo = 'port'"
              :class="transportTo === 'port' 
                  ? 'bg-orange-600 text-white' 
                  : 'bg-white text-gray-700 border border-transparent'"
              class="px-4 py-2 rounded-full font-medium transition-colors duration-200"
          >
              Port
          </button>
      </div>
      
      <div class="h-16 relative">
          <!-- City/ZIP Input Field -->
          <div 
              x-show="transportTo === 'city'" 
              x-transition:enter="transition ease-out duration-300"
              x-transition:enter-start="opacity-0 transform translate-y-2"
              x-transition:enter-end="opacity-100 transform translate-y-0"
              x-transition:leave="transition ease-in duration-200"
              x-transition:leave-start="opacity-100 transform translate-y-0"
              x-transition:leave-end="opacity-0 transform -translate-y-2"
              class="absolute inset-0"
          >
              <input 
                  type="text" 
                  placeholder="e.g., Miami, 33101"
                  class="w-full px-4 py-3 rounded-2xl bg-gray-50 border border-gray-200 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent placeholder-gray-400"
              >
          </div>
          
          <!-- Port Dropdown Field -->
          <div 
              x-show="transportTo === 'port'" 
              x-transition:enter="transition ease-out duration-300"
              x-transition:enter-start="opacity-0 transform translate-y-2"
              x-transition:enter-end="opacity-100 transform translate-y-0"
              x-transition:leave="transition ease-in duration-200"
              x-transition:leave-start="opacity-100 transform translate-y-0"
              x-transition:leave-end="opacity-0 transform -translate-y-2"
              class="absolute inset-0"
              class="absolute inset-0"
          >
              <div class="relative">
                  <select 
                      class="w-full px-4 py-3 rounded-2xl bg-gray-50 border border-gray-200 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent appearance-none cursor-pointer"
                  >
                      <option value="" disabled selected>Please select a port</option>
                      <option value="honolulu-hi">Honolulu, HI</option>
                      <option value="hilo-hi">Hilo, HI</option>
                      <option value="nawiliwili-hi">Nawiliwili, HI</option>
                      <option value="kahului-hi">Kahului, HI</option>
                      <option value="san-juan-pr">San Juan, PR</option>
                      <option value="long-beach-ca">Long Beach, CA</option>
                      <option value="oakland-ca">Oakland, CA</option>
                      <option value="tacoma-wa">Tacoma, WA</option>
                      <option value="jacksonville-fl">Jacksonville, FL</option>
                      <option value="eddystone-pa">Eddystone, PA</option>
                  </select>
                  <!-- Custom Chevron Icon -->
                  <div class="absolute right-4 top-1/2 transform -translate-y-1/2 pointer-events-none">
                      <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                      </svg>
                  </div>
              </div>
          </div>
      </div>
  </div>

  <!-- Next Button -->
  <button 
      class="w-full bg-orange-600 text-white py-3.5 px-6 rounded-2xl font-semibold text-lg hover:bg-blue-600 transition-colors duration-200 flex items-center justify-center gap-3"
  >
      Next - Vehicle Details
      <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
          <path d="M17.5383 11.1633L11.9133 16.7883C11.7372 16.9644 11.4983 17.0634 11.2492 17.0634C11.0001 17.0634 10.7613 16.9644 10.5852 16.7883C10.409 16.6122 10.3101 16.3733 10.3101 16.1242C10.3101 15.8752 10.409 15.6363 10.5852 15.4602L14.6094 11.4375H3.125C2.87636 11.4375 2.6379 11.3387 2.46209 11.1629C2.28627 10.9871 2.1875 10.7487 2.1875 10.5C2.1875 10.2514 2.28627 10.0129 2.46209 9.8371C2.6379 9.66129 2.87636 9.56252 3.125 9.56252H14.6094L10.5867 5.53751C10.4106 5.36139 10.3117 5.12252 10.3117 4.87345C10.3117 4.62438 10.4106 4.38551 10.5867 4.20939C10.7628 4.03327 11.0017 3.93433 11.2508 3.93433C11.4999 3.93433 11.7387 4.03327 11.9148 4.20939L17.5398 9.83439C17.6273 9.9216 17.6966 10.0252 17.7438 10.1393C17.7911 10.2534 17.8153 10.3757 17.8152 10.4992C17.815 10.6226 17.7905 10.7449 17.743 10.8589C17.6955 10.9728 17.6259 11.0763 17.5383 11.1633Z" fill="white"/>
      </svg>
  </button>
</form>

<script>
function transportForm() {
  return {
      transportFrom: 'city',  // Default: City/ZIP selected
      transportTo: 'port',    // Default: Port selected
      
      init() {
          // Initialize with default values
      }
  }
}
</script>