<!-- Progress Stepper -->
<div class="flex flex-col md:flex-row lg:gap-20">
  <!-- Left Panel: Vertical Stepper -->
  <div class="md:w-[280px]" x-show="step !== 5">
    <div class="mb-6">
      <h2 class="text-lg font-bold text-gray-900 mb-2">Step <span x-text="step"></span> <span class="block text-2xl" x-text="step === 1 ? 'Shipping Route Details' : step === 2 ? 'Vehicle Details' : step === 3 ? 'Contact Details' : step === 4 ? 'Summary' : 'Payment'"></span></h2>
      <p class="text-gray-600 text-sm">
        <span x-show="step === 1">Choose pickup and delivery locations and set transport direction.</span>
        <span x-show="step === 2">Provide necessary information about your vehicle.</span>
        <span x-show="step === 3">Enter your contact details and preferred shipping date.</span>
        <span x-show="step === 4">Review your shipping details and quote.</span>
        <span x-show="step === 5">Complete your payment to secure your booking.</span>
      </p>
    </div>
    
    <!-- Vertical Progress Steps -->
    <div class="space-y-4">
      <!-- Step 1 -->
      <div class="flex items-center">
        <div 
          :class="step > 1 ? 'bg-blue-600 text-white' : step === 1 ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-500'"
          class="w-8 h-8 rounded-full flex items-center justify-center font-semibold text-sm transition-colors duration-200"
        >
          <span x-show="step > 1">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
          </span>
          <span x-show="step <= 1">1</span>
        </div>
        <div class="ml-3">
          <div 
            :class="step >= 1 ? 'text-blue-600' : 'text-gray-500'"
            class="text-sm font-medium transition-colors duration-200"
          >
            Shipping Route Details
          </div>
        </div>
      </div>
      
      <!-- Connector Line -->
      <div 
        :class="step >= 2 ? 'bg-blue-600' : 'bg-gray-200'"
        class="w-0.5 h-6 ml-4 transition-colors duration-200"
      ></div>
      
      <!-- Step 2 -->
      <div class="flex items-center">
        <div 
          :class="step >= 2 ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-500'"
          class="w-8 h-8 rounded-full flex items-center justify-center font-semibold text-sm transition-colors duration-200"
        >
          <span x-show="step > 2">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
          </span>
          <span x-show="step <= 2">2</span>
        </div>
        <div class="ml-3">
          <div 
            :class="step >= 2 ? 'text-blue-600' : 'text-gray-500'"
            class="text-sm font-medium transition-colors duration-200"
          >
            Vehicle Details
          </div>
        </div>
      </div>
      
      <!-- Connector Line -->
      <div 
        :class="step >= 3 ? 'bg-blue-600' : 'bg-gray-200'"
        class="w-0.5 h-6 ml-4 transition-colors duration-200"
      ></div>
      
      <!-- Step 3 -->
      <div class="flex items-center">
        <div 
          :class="step >= 3 ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-500'"
          class="w-8 h-8 rounded-full flex items-center justify-center font-semibold text-sm transition-colors duration-200"
        >
          <span x-show="step > 3">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
          </span>
          <span x-show="step <= 3">3</span>
        </div>
        <div class="ml-3">
          <div 
            :class="step >= 3 ? 'text-blue-600' : 'text-gray-500'"
            class="text-sm font-medium transition-colors duration-200"
          >
            Contact Details
          </div>
        </div>
      </div>
      
      <!-- Connector Line -->
      <div 
        :class="step >= 4 ? 'bg-blue-600' : 'bg-gray-200'"
        class="w-0.5 h-6 ml-4 transition-colors duration-200"
      ></div>
      
      <!-- Step 4 -->
      <div class="flex items-center">
        <div 
          :class="step >= 4 ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-500'"
          class="w-8 h-8 rounded-full flex items-center justify-center font-semibold text-sm transition-colors duration-200"
        >
          <span x-show="step > 4">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
          </span>
          <span x-show="step <= 4">4</span>
        </div>
        <div class="ml-3">
          <div 
            :class="step >= 4 ? 'text-blue-600' : 'text-gray-500'"
            class="text-sm font-medium transition-colors duration-200"
          >
            Summary
          </div>
        </div>
      </div>
    </div>
  </div>
  
  <!-- Right Panel: Form Content -->
  <div :class="step === 5 ? 'md:w-full' : 'md:w-2/3'">
    <div x-cloak>
      <!-- Step 1: Route Details -->
      <div x-show="step === 1" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
        @include('quote.steps._route')
      </div>
      
      <!-- Step 2: Vehicle Details -->
      <div x-show="step === 2" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
        @include('quote.steps._vehicle')
      </div>
      
      <!-- Step 3: Contact Details -->
      <div x-show="step === 3" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
        @include('quote.steps._contact')
      </div>
      
      <!-- Step 4: Summary -->
      <div x-show="step === 4" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
        @include('quote.steps._summary')
      </div>
      
      <!-- Step 5: Payment -->
      <div x-show="step === 5" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
        @include('quote.steps._payment')
      </div>
    </div>
  </div>
</div>
