<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject ?? 'Quote Form Notification' }}</title>
</head>
<body style="margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif; background-color: #f5f5f5;">
    <table role="presentation" style="width: 100%; border-collapse: collapse; background-color: #f5f5f5; padding: 20px;">
        <tr>
            <td align="center">
                <table role="presentation" style="max-width: 600px; width: 100%; border-collapse: collapse; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <!-- Header -->
                    <tr>
                        <td style="background-color: #ea580c; padding: 30px 20px; text-align: center;">
                            <h1 style="margin: 0; color: #ffffff; font-size: 24px; font-weight: bold;">{{ $type === 'booking' ? 'New Booking Received' : 'New Quote Request' }}</h1>
                        </td>
                    </tr>
                    
                    <!-- Content -->
                    <tr>
                        <td style="padding: 30px 20px;">
                            <p style="margin: 0 0 20px 0; color: #374151; font-size: 16px; line-height: 1.6;">
                                {{ $type === 'booking' ? 'A new booking has been received with successful payment.' : 'A new quote request has been submitted.' }}
                            </p>

                            <!-- Shipping Route Details -->
                            <div style="background-color: #f9fafb; border-left: 4px solid #ea580c; padding: 20px; margin-bottom: 20px; border-radius: 4px;">
                                <h2 style="margin: 0 0 15px 0; color: #111827; font-size: 18px; font-weight: bold;">Shipping Route Details</h2>
                                <table role="presentation" style="width: 100%; border-collapse: collapse;">
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px; width: 40%;">Transport From:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; font-weight: 600;">{{ $data['from_location'] ?? '—' }}</td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Transport To:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; font-weight: 600;">{{ $data['to_location'] ?? '—' }}</td>
                                    </tr>
                                </table>
                            </div>

                            <!-- Vehicle Details -->
                            <div style="background-color: #f9fafb; border-left: 4px solid #ea580c; padding: 20px; margin-bottom: 20px; border-radius: 4px;">
                                <h2 style="margin: 0 0 15px 0; color: #111827; font-size: 18px; font-weight: bold;">
                                    Vehicle Details 
                                    <span style="font-size: 14px; font-weight: normal; color: #6b7280;">({{ count($data['vehicles'] ?? []) }} {{ count($data['vehicles'] ?? []) === 1 ? 'vehicle' : 'vehicles' }})</span>
                                </h2>
                                @if(!empty($data['vehicles']))
                                    @foreach($data['vehicles'] as $index => $vehicle)
                                        <div style="margin-bottom: {{ $loop->last ? '0' : '15px' }}; padding-bottom: {{ $loop->last ? '0' : '15px' }}; border-bottom: {{ $loop->last ? 'none' : '1px solid #e5e7eb' }};">
                                            <h3 style="margin: 0 0 10px 0; color: #374151; font-size: 16px; font-weight: 600;">Vehicle {{ $index + 1 }}</h3>
                                            <table role="presentation" style="width: 100%; border-collapse: collapse;">
                                                <tr>
                                                    <td style="padding: 6px 0; color: #6b7280; font-size: 14px; width: 40%;">Year:</td>
                                                    <td style="padding: 6px 0; color: #111827; font-size: 14px;">{{ $vehicle['year'] ?? '—' }}</td>
                                                </tr>
                                                <tr>
                                                    <td style="padding: 6px 0; color: #6b7280; font-size: 14px;">Make:</td>
                                                    <td style="padding: 6px 0; color: #111827; font-size: 14px;">{{ $vehicle['make'] ?? '—' }}</td>
                                                </tr>
                                                <tr>
                                                    <td style="padding: 6px 0; color: #6b7280; font-size: 14px;">Model:</td>
                                                    <td style="padding: 6px 0; color: #111827; font-size: 14px;">{{ $vehicle['model'] ?? '—' }}</td>
                                                </tr>
                                                <tr>
                                                    <td style="padding: 6px 0; color: #6b7280; font-size: 14px;">Operable:</td>
                                                    <td style="padding: 6px 0; color: #111827; font-size: 14px;">{{ ($vehicle['operable'] ?? false) ? 'Yes' : 'No' }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                    @endforeach
                                @else
                                    <p style="margin: 0; color: #6b7280; font-size: 14px;">No vehicle details provided.</p>
                                @endif
                            </div>

                            <!-- Contact Information -->
                            <div style="background-color: #f9fafb; border-left: 4px solid #ea580c; padding: 20px; margin-bottom: 20px; border-radius: 4px;">
                                <h2 style="margin: 0 0 15px 0; color: #111827; font-size: 18px; font-weight: bold;">Contact Information</h2>
                                <table role="presentation" style="width: 100%; border-collapse: collapse;">
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px; width: 40%;">Name:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; font-weight: 600;">{{ ($data['first_name'] ?? '') . ' ' . ($data['last_name'] ?? '') }}</td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Email:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px;">
                                            <a href="mailto:{{ $data['email'] ?? '' }}" style="color: #ea580c; text-decoration: none;">{{ $data['email'] ?? '—' }}</a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Phone:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px;">
                                            <a href="tel:{{ $data['phone'] ?? '' }}" style="color: #111827; text-decoration: none;">{{ $data['phone'] ?? '—' }}</a>
                                        </td>
                                    </tr>
                                    @if(!empty($data['pickup_date']))
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Estimated Pickup Date:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px;">{{ $data['pickup_date'] }}</td>
                                    </tr>
                                    @endif
                                </table>
                            </div>

                            @if($type === 'booking')
                            <!-- Payment Details -->
                            <div style="background-color: #f0fdf4; border-left: 4px solid #22c55e; padding: 20px; margin-bottom: 20px; border-radius: 4px;">
                                <h2 style="margin: 0 0 15px 0; color: #111827; font-size: 18px; font-weight: bold;">Payment Details</h2>
                                <table role="presentation" style="width: 100%; border-collapse: collapse;">
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px; width: 40%;">Amount:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 18px; font-weight: bold;">${{ number_format(($data['amount_cents'] ?? 0) / 100, 2) }} {{ strtoupper($data['currency'] ?? 'USD') }}</td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Status:</td>
                                        <td style="padding: 8px 0; color: #22c55e; font-size: 14px; font-weight: 600;">Paid</td>
                                    </tr>
                                    @if(!empty($data['booking_id']))
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Booking ID:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; font-family: monospace;">{{ $data['booking_id'] }}</td>
                                    </tr>
                                    @endif
                                </table>
                            </div>
                            @endif

                            <!-- Footer -->
                            <p style="margin: 30px 0 0 0; padding-top: 20px; border-top: 1px solid #e5e7eb; color: #6b7280; font-size: 14px; text-align: center;">
                                This is an automated notification from the Coastal Auto Shipping quote form system.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>

