<footer>
    <div class="container max-sm:flex-col max-sm:text-center max-sm:items-center flex max-xl:flex-wrap items-start lg:justify-between gap-10 pt-16 lg:pt-52">
        <x-logo type="{{ 'primary' }}" class="inline-block flex-shrink-0 max-xl:basis-full" />
        <div>
            @include('partials.footer-navigation')
        </div>
        <div>
            <div class="mb-8">
                <p class="font-bold leading-160">Address</p>
                @options('office_locations')
                    @if(get_sub_field('address_line_1'))
                        <a href="@sub('address_url')" class="block mb-2 hover:text-orange-600 transition-all" target="_blank" title="Visit Our @sub('location_name')">
                            @sub('address_line_1')<br> @sub('address_line_2')
                        </a>
                    @endif
                @endoptions
            </div>
            <div>
                <p class="font-bold leading-160">Email</p>
                <a href="mailto:@option('contact_information', 'email_address')" class="hover:text-orange-600 transition-all" target="_blank" title="Email Us">
                    @option('contact_information', 'email_address')
                </a>
            </div>
        </div>
        <div class="max-sm:block max-lg:flex flex-wrap gap-10">
            <div class="mb-8">
                <p class="font-bold leading-160 mb-2">Call Us Today</p>
                <a href="tel:@option('contact_information', 'phone_number')" class="flex items-center gap-1.5 py-3 px-5 border-2 border-orange-600 rounded-2xl font-semibold group flex-shrink-0 bg-orange-600 text-white hover:bg-blue-600 hover:border-blue-600 hover:text-white w-fit transition-all" title="Call Us">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none" class="group-hover:animate-phone-wiggle origin-center">
                        <path d="M18.1156 13.6781C17.9763 14.7367 17.4564 15.7085 16.6531 16.4118C15.8497 17.1151 14.8177 17.5019 13.75 17.5C7.54688 17.5 2.50001 12.4531 2.50001 6.25C2.49809 5.18226 2.88492 4.15033 3.58824 3.34695C4.29155 2.54357 5.26326 2.02368 6.32188 1.88438C6.58958 1.85169 6.86067 1.90646 7.09468 2.0405C7.3287 2.17455 7.51309 2.38068 7.62032 2.62813L9.27032 6.31172V6.3211C9.35242 6.51051 9.38633 6.71731 9.36901 6.92303C9.3517 7.12875 9.2837 7.32697 9.1711 7.5C9.15704 7.5211 9.14219 7.54063 9.12657 7.56016L7.50001 9.48828C8.08516 10.6773 9.32891 11.9102 10.5336 12.4969L12.4352 10.8789C12.4538 10.8632 12.4734 10.8486 12.4938 10.8352C12.6666 10.7198 12.8655 10.6495 13.0725 10.6304C13.2794 10.6113 13.4878 10.6441 13.6789 10.7258L13.6891 10.7305L17.3695 12.3797C17.6174 12.4865 17.8241 12.6708 17.9585 12.9048C18.093 13.1389 18.1481 13.4102 18.1156 13.6781Z" fill="currentColor"/>
                    </svg>
                    @option('contact_information', 'phone_number')
                </a>
            </div>
            <div>
                <p class="font-bold leading-160 mb-2">Follow Us</p>
                <x-social-media />
            </div>
        </div>
    </div>
    <div class="container text-center pb-16 lg:pb-28 pt-10 lg:pt-32">
        <p>&copy; {{ date('Y') }} {!! $siteName !!}. All Rights Reserved.</p>
        <a href="https://www.onthemap.com/" title="Visit On The Map" target="_blank" class="inline-block w-fit mx-auto mt-5">
            <img width="150" height="38" src="@asset('images/branding/otm.svg')" title="On The Map, Inc" alt="On The Map, Inc Logo" loading="lazy">
        </a>
    </div>
</footer>
<button 
    x-data="{ show: false }"
    x-show="show"
    x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 transform scale-90"
    x-transition:enter-end="opacity-100 transform scale-100"
    x-transition:leave="transition ease-in duration-300"
    x-transition:leave-start="opacity-100 transform scale-100"
    x-transition:leave-end="opacity-0 transform scale-90"
    @scroll.window="show = window.pageYOffset > 300"
    @click="window.scrollTo({ top: 0, behavior: 'smooth' })"
    class="fixed bottom-5 right-5 bg-blue-600 hover:bg-orange-600 text-white rounded-full p-2 lg:p-3 shadow-lg transition-all duration-300 z-50"
    title="Back to Top">
    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-up"><path d="M12 19V5"/><path d="M5 12l7-7 7 7"/></svg>
</button>