<div class="bg-navy-800 text-white py-3 overflow-hidden">
    <div x-data="{ 
        text: 'Coastal Auto Shipping, experts in Car Shipping to or from Hawaii and Puerto Rico. The busy season is here plan in advance to save time and money. Call us today to find out how we can help you!',
        position: 0,
        speed: 1.75,
        textWidth: 0,
        init() {
            this.$nextTick(() => {
                this.textWidth = this.$refs.text.offsetWidth;
                this.position = window.innerWidth / 1;
                this.startTicker();
            });
        },
        startTicker() {
            const move = () => {
                this.position -= this.speed;
                if (this.position <= -this.textWidth) {
                    this.position += this.textWidth;
                }
                requestAnimationFrame(move);
            };
            requestAnimationFrame(move);
        }
    }" class="relative">
        <div class="whitespace-nowrap" :style="`transform: translateX(${position}px)`">
            <span x-ref="text" class="inline-block pr-8" x-text="text"></span>
            <span class="inline-block pr-8" x-text="text"></span>
            <span class="inline-block pr-8" x-text="text"></span>
        </div>
    </div>
</div>
<header 
x-data="{ scrolled: false }" 
    @scroll.window="scrolled = window.pageYOffset > 48"
    :class="{ 'drop-shadow-md sticky top-0': scrolled }"
    class="bg-white transition-all z-[999]"
>
    <div class="container flex items-center justify-between gap-3 py-2">
        <x-logo class="inline-block w-fit" />
        <div class="max-xl:order-3">
            @include('partials.navigation')
        </div>
        <div class="flex items-center gap-7 max-xl:ml-auto">
            <span class="font-semibold text-lg max-md:hidden">Se Habla Español</span>
            <a href="tel:@option('contact_information', 'phone_number')" class="flex items-center gap-1.5 py-3 max-sm:px-3 px-5 border-2 max-sm:bg-orange-600 max-sm:text-white max-sm:hover:bg-blue-600 max-sm:hover:border-blue-600 hover:text-white hover:bg-orange-600 border-orange-600 rounded-2xl font-semibold text-navy-950 group flex-shrink-0 transition-all" title="Call Us">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none" class="group-hover:animate-phone-wiggle origin-center">
                    <path d="M18.1156 13.6781C17.9763 14.7367 17.4564 15.7085 16.6531 16.4118C15.8497 17.1151 14.8177 17.5019 13.75 17.5C7.54688 17.5 2.50001 12.4531 2.50001 6.25C2.49809 5.18226 2.88492 4.15033 3.58824 3.34695C4.29155 2.54357 5.26326 2.02368 6.32188 1.88438C6.58958 1.85169 6.86067 1.90646 7.09468 2.0405C7.3287 2.17455 7.51309 2.38068 7.62032 2.62813L9.27032 6.31172V6.3211C9.35242 6.51051 9.38633 6.71731 9.36901 6.92303C9.3517 7.12875 9.2837 7.32697 9.1711 7.5C9.15704 7.5211 9.14219 7.54063 9.12657 7.56016L7.50001 9.48828C8.08516 10.6773 9.32891 11.9102 10.5336 12.4969L12.4352 10.8789C12.4538 10.8632 12.4734 10.8486 12.4938 10.8352C12.6666 10.7198 12.8655 10.6495 13.0725 10.6304C13.2794 10.6113 13.4878 10.6441 13.6789 10.7258L13.6891 10.7305L17.3695 12.3797C17.6174 12.4865 17.8241 12.6708 17.9585 12.9048C18.093 13.1389 18.1481 13.4102 18.1156 13.6781Z" fill="currentColor"/>
                </svg>
                <span class="max-sm:hidden">@option('contact_information', 'phone_number')</span>
            </a>
        </div>
    </div>
</header>