<section class="py-16 md:py-20 lg:py-52">
    <div class="container max-w-[952px] text-center">
        <p class="subheading mb-3">How It Works</p>
        <h2 class="mb-6 lg:mb-9 lg:text-5xl !leading-130">The Shipping Process</h2>
        <p>Shipping a car to or from Hawaii involves several distinct steps, from determining the right method of transport to managing logistics between mainland ports and delivery locations.</p>
    </div>
    <div class="container grid lg:grid-cols-2 gap-3 lg:gap-8 mt-9 lg:mt-14">
        <div class="p-6 lg:p-10 bg-white border-2 border-blue-50 rounded-[32px]">
            <x-icon-ship />
            <h3 class="h5 mb-4 mt-5 lg:mt-8">Port to Port Service</h3>
            <div class="text-content">
                <p>The journey begins at mainland ports, where the car is prepared for shipping. Key ports often used include Long Beach, Oakland, and Seattle. The vehicle is then loaded onto a specialized vessel designed for car shipments.</p>
                <p>Our Hawaii car transport company handles everything from securing the vehicle to managing the entire process of transit. Transit times vary, but it typically takes about 7-14 days. Customers can expect to receive tracking updates to monitor the progress of the car shipped to the Hawaiian shores.</p>
                <p>Upon arrival, the car is unloaded at Hawaiian ports such as Honolulu or Hilo. Importantly, documentation must be in order, which includes proof of ownership and car registration. Customs can delay the shipping process if paperwork is incomplete.</p>
            </div>
        </div>
        <div class="p-6 lg:p-10 bg-white border-2 border-blue-50 rounded-[32px]">
            <x-icon-ship />
            <h3 class="h5 mb-4 mt-5 lg:mt-8">Choosing Between Port to Port and Door to Door Services</h3>
            <div class="text-content">
                <p>There are two primary service options: Port to Port and Door to Door. A Port to Port service (also referred to as terminal to terminal) requires the vehicle to be dropped off at, and picked up from, the port. This method is often cheaper and involves less coordination with the Hawaiian and mainland port.</p>
                <p>Door to Door services offer greater convenience. Our Hawaii car transport company can arrange for your car to be picked up from your home and delivered directly to the final destination in Hawaii. This option is more expensive but can save significant time and effort.</p>
                <p>While both options ensure safe transport, the choice between them depends on the owner&rsquo;s budget and convenience needs. Careful consideration of these factors can make the entire process smoother and faster.</p>
            </div>
        </div>
    </div>
</section>