<section class="pb-16 md:pb-20 lg:pb-52">
    <div class="container grid lg:grid-cols-2 gap-3 lg:gap-8 mt-9 lg:mt-14">
        <div class="mb-6">
            <p class="subheading mb-3">How It Works</p>
            <h2 class="mb-6 lg:mb-9 lg:text-5xl !leading-130">Understanding Hawaii Freight Shipping Options</h2>
            <p>Shipping freight to Hawaii involves choosing between air and ocean transport, understanding different container load options, and recognizing the significance of West Coast ports.</p>
            <p class="font-mplus font-bold text-2xl mt-6 lg:mt-9">Need reliable car shipping <br>to Hawaii or Puerto Rico?</p>
            <x-button type="primary" class="block w-fit mt-6" href="#">Get Free Instant Quote</x-button>
        </div>
        <div class="p-6 lg:p-10 bg-white border-2 border-blue-50 rounded-[32px]">
            <x-icon-ship />
            <h3 class="h5 mb-4 mt-5 lg:mt-8">Air Freight Versus Ocean Freight</h3>
            <div class="text-content">
                <p>Air freight offers speed and security, making it the fastest shipping method to Hawaii. It is ideal for smaller, time-sensitive shipments. However, air freight tends to be more expensive compared to other methods.</p>
                <p>Ocean freight is more economical and suitable for larger, heavier shipments. It involves longer transit times but can handle oversized items that air freight cannot. For example, shipping large commercial cargo via ocean freight to Honolulu Harbor takes about five days from the West Coast, excluding additional handling time on either end.</p>
            </div>
        </div>
        <div class="p-6 lg:p-10 bg-white border-2 border-blue-50 rounded-[32px]">
            <x-icon-ship />
            <h3 class="h5 mb-4 mt-5 lg:mt-8">Evaluating Full Container Load and Less Than Container Load</h3>
            <div class="text-content">
                <p>Full Container Load (FCL) shipments mean the entire container is used by one customer. This method provides better value if shipping large volumes since it maximizes use of space.</p>
                <p>Less Than Container Load (LCL) is a cost-effective solution for smaller shipments that do not require a full container. With LCL, multiple customers&rsquo; goods share a single container, reducing costs but potentially complicating logistics due to the need for consolidation and deconsolidation.</p>
            </div>
        </div>
        <div class="p-6 lg:p-10 bg-white border-2 border-blue-50 rounded-[32px]">
            <x-icon-ship />
            <h3 class="h5 mb-4 mt-5 lg:mt-8">The Role of West Coast Ports in Hawaii Shipping</h3>
            <div class="text-content">
                <p>West Coast ports, such as those in Los Angeles, Long Beach, and Oakland, serve as crucial gateways for ocean freight to Hawaii. These ports handle a significant volume of cargo bound for the Hawaiian Islands, ensuring steady and reliable transport of goods.</p>
                <p>These ports play a vital role in both FCL and LCL shipments. Efficient operations at these ports are essential for maintaining the flow of goods and keeping transit times manageable. This connectivity between the West Coast and Hawaii supports both personal and commercial shipping needs.</p>
            </div>
        </div>
    </div>
</section>