@hasoption('testimonials')
<div class="testimonials-slider py-15 lg:py-30 relative z-10">
    <div class="container px-3.75">
        <div class="heading lg:grid mb-7.5 lg:mb-15">
            <div>
                <div class="sub-head has-line-before mb-2.5 lg:mb-5">Client Reviews</div>
                <h2>See What Our Clients are Saying</h2>
            </div>
            <div class="slider-nav">
                <div class="t-prev">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M15.75 4.5L8.25 12L15.75 19.5" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <div class="t-next">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M8.25 4.5L15.75 12L8.25 19.5" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </div>
        </div>
        <div class="swiper testimonials-swiper">
            <div class="swiper-wrapper items-stretch">
                @options('testimonials')
                    <div class="swiper-slide p-5 lg:p-10">
                        <svg xmlns="http://www.w3.org/2000/svg" class="mb-3.75 lg:mb-7.5" width="80" height="60" viewBox="0 0 80 60" fill="none">
                            <path d="M40.3509 20.4706C40.3509 33.8824 24.9123 53.2941 10.1754 60C16.1404 51.5294 18.9474 43.4118 18.9474 36C18.9474 23.2941 12.6316 16.9412 0 16.9412C4.91228 5.64708 12.2807 3.8147e-06 21.4035 3.8147e-06C30.5263 3.8147e-06 38.2456 6.35294 40 15.8824C44.9123 5.29414 52.2807 3.8147e-06 61.4035 3.8147e-06C71.2281 3.8147e-06 80 8.4706 80 20.4706C80 33.8824 64.5614 53.2941 50.1754 60C55.7895 51.5294 58.5965 43.4118 58.5965 36C58.5965 23.2941 52.6316 16.9412 40.3509 16.9412V20.4706Z" fill="white"/>
                        </svg>
                        <p class="mb-3.75 lg:mb-7.5">@sub('review')</p>
                        <div class="stars mb-1.25 flex gap-1.25">
                            @for ($i = 0; $i < get_sub_field('rating'); $i++)
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.788 3.20997C11.236 2.13297 12.764 2.13297 13.212 3.20997L15.294 8.21597L20.698 8.64997C21.862 8.74297 22.334 10.195 21.447 10.955L17.33 14.482L18.587 19.755C18.858 20.891 17.623 21.788 16.627 21.18L12 18.354L7.373 21.18C6.377 21.788 5.142 20.89 5.413 19.755L6.67 14.482L2.553 10.955C1.666 10.195 2.138 8.74297 3.302 8.64997L8.706 8.21597L10.788 3.20997Z" fill="#EC1F27"/>
                                </svg>
                            @endfor
                        </div>
                        <p class="author">@sub('author')</p>
                    </div>
                @endoptions
            </div>
        </div>
    </div>
</div>
@endoption

@push('after-scripts')
    <script>
        var badgeSlider = new Swiper(".testimonials-swiper", {
            loop: true,
            spaceBetween: 30,
            slidesPerView: 'auto',
            autoHeight: false,
            speed: 1000,
            navigation: {
                nextEl: ".t-next",
                prevEl: ".t-prev",
            }
        });
    </script>
@endpush