<section class="pt-16 md:pt-20 lg:pt-52">
	<div class="container">
        <div class="grid lg:grid-cols-2 items-end gap-8 mb-9 lg:mb-24">
            <div>
                <p class="subheading mb-3">Our Locations</p>
                <h2>Car Shipping Across the U.S. & Beyond</h2>
            </div>
            <div>
                <p>Find our offices in key locations to ensure smooth, reliable vehicle shipping across the U.S. and beyond.</p>
                <x-button type="primary" class="inline-block w-fit mt-8" href="#">Get a Quote Today</x-button>
            </div>
        </div>
		<div class="grid md:grid-cols-2 gap-10">
			@options('office_locations')
				<div class="grid gap-7">
					<div class="grid grid-cols-[24px_1fr] gap-4">
						<svg xmlns="http://www.w3.org/2000/svg" class="mt-0.5" width="24" height="24" viewBox="0 0 24 24" fill="none">
							<path d="M12 1.5C9.81273 1.50248 7.71575 2.37247 6.16911 3.91911C4.62247 5.46575 3.75248 7.56273 3.75 9.75C3.75 16.8094 11.25 22.1409 11.5697 22.3641C11.6958 22.4524 11.846 22.4998 12 22.4998C12.154 22.4998 12.3042 22.4524 12.4303 22.3641C12.75 22.1409 20.25 16.8094 20.25 9.75C20.2475 7.56273 19.3775 5.46575 17.8309 3.91911C16.2843 2.37247 14.1873 1.50248 12 1.5ZM12 6.75C12.5933 6.75 13.1734 6.92595 13.6667 7.25559C14.1601 7.58524 14.5446 8.05377 14.7716 8.60195C14.9987 9.15013 15.0581 9.75333 14.9424 10.3353C14.8266 10.9172 14.5409 11.4518 14.1213 11.8713C13.7018 12.2909 13.1672 12.5766 12.5853 12.6924C12.0033 12.8081 11.4001 12.7487 10.8519 12.5216C10.3038 12.2946 9.83524 11.9101 9.50559 11.4167C9.17595 10.9234 9 10.3433 9 9.75C9 8.95435 9.31607 8.19129 9.87868 7.62868C10.4413 7.06607 11.2044 6.75 12 6.75Z" fill="#4668C4"/>
						</svg>
						@if(get_sub_field('address_line_1'))
						<div>
							<p class="text-xl font-semibold mb-2">@sub('location_name')</p>
							<a href="@sub('address_url')" class="hover:text-orange-600 transition-all" target="_blank" title="Visit Our @sub('location_name')">
								@sub('address_line_1')<br> @sub('address_line_2')
							</a>
						</div>
						@endif
					</div>
					<div>
						<iframe class="bg-blue-50 h-[300px]" src="@sub('map_url')" width="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
					</div>
				</div>
			@endoptions
		</div>
	</div>
</section>