<?php $homepage_id = get_option('page_on_front'); ?>

<?php if(have_rows('faq', $homepage_id)): ?>
    <section class="bg-oyster100 py-20 lg:py-40">
        <div class="container">
            <div class="grid lg:grid-cols-[384px_1fr] items-start gap-8">
                <div class="lg:pr-7">
                    <p class="pre-head mb-2 lg:mb-7">Clarifying the Legal Process</p>
                    <h2 class="h1 mb-7"><span class="font-libre italic">Frequently</span> Asked Questions</h2>
                    <p>We know legal matters can feel overwhelming, so we've made it simple. Here are answers to the most common questions—if you need more clarity, we're just a call away.</p>
                    <div class="max-lg:hidden">
                        <div class="h-0.25 bg-oyster300 my-7"></div>
                        <h3 class="mb-4">Need Answers Fast?</h3>
                        <p class="mb-6">Get clear, straightforward legal guidance from our experienced team. Call today!</p>
                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => ['href' => 'tel:'.e(get_field('contact_information', 'option')['phone_number']).'','title' => 'Call Us','type' => 'primary']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['href' => 'tel:'.e(get_field('contact_information', 'option')['phone_number']).'','title' => 'Call Us','type' => 'primary']); ?>Call Now <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                    </div>
                </div>
                <div x-data="{ selected : 0 }" class="bg-white p-5 lg:p-12 border border-oyster200 rounded-2xl">
                    <?php $count = 1; ?>
                    <?php while(have_rows('faq', $homepage_id)): ?> <?php the_row(); ?>
                        <div @click="selected !== <?php echo e($count); ?> ? selected = <?php echo e($count); ?> : selected = null" class="h-auto cursor-pointer group pt-6 first:pt-0 last:pb-0 transition-all">
                            <div class="flex items-center gap-6">
                                <h3 class="flex-grow text-18px font-medium flex items-center group-hover:text-red700 transition-all" :class="selected == <?php echo e($count); ?> ? 'text-red700' : ''"><?php echo e(get_sub_field('question')); ?></h3>
                                <span class="w-7 h-7 flex justify-center items-center rounded-full flex-shrink-0 border-2 border-red700 transition-all" :class="selected == <?php echo e($count); ?> ? '' : ''">
                                    <svg class="transition-all duration-200" width="12" height="12" xmlns="http://www.w3.org/2000/svg">
                                        <rect y="5" width="16" height="2" rx="0" class="transform origin-center transition-all" :class="selected == <?php echo e($count); ?> ? '!rotate-180' : ''" fill="#9f3531"></rect>
                                        <rect y="5" width="16" height="2" rx="0" class="transform origin-center rotate-90 transition-all" :class="selected == <?php echo e($count); ?> ? '!rotate-180' : ''" fill="#9f3531"></rect>
                                    </svg>
                                </span>
                            </div>
                            <div class="relative overflow-hidden transition-all space-y-5 pr-12.75" :class="selected == <?php echo e($count); ?> ? 'pt-2.5' : ''" x-ref="container<?php echo e($count); ?>" x-bind:style="selected == <?php echo e($count); ?> ? 'max-height: ' + ($refs.container<?php echo e($count); ?> .scrollHeight + 10) + 'px' : 'max-height: 0'">
                                <?php echo get_sub_field('answer'); ?>

                            </div>
                        </div>
                        <?php $count++; ?>
                    <?php endwhile; ?>
                </div>
            </div>
            <div class="lg:hidden">
                <div class="h-0.25 bg-oyster300 my-7"></div>
                <h3 class="mb-4">Need Answers Fast?</h3>
                <p class="mb-6">Get clear, straightforward legal guidance from our experienced team. Call today!</p>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => ['href' => 'tel:'.e(get_field('contact_information', 'option')['phone_number']).'','title' => 'Call Us','type' => 'primary']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['href' => 'tel:'.e(get_field('contact_information', 'option')['phone_number']).'','title' => 'Call Us','type' => 'primary']); ?>Call Now <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
            </div>
        </div>
    </section>
<?php endif; ?><?php /**PATH /var/www/vhosts/jacobsandjacobs.net/httpdocs/resources/views/sections/homepage/faq.blade.php ENDPATH**/ ?>