<?php
$types = [
    'primary' => 'logo',
    'secondary' => 'logo_secondary',
    'mobile' => 'logo_mobile',
];

$logo = get_field('branding', 'option')[$types[$attributes->get('type', 'primary')]];
$logoWebp = get_field('branding', 'option')[$types[$attributes->get('type', 'primary')] . '_webp'];
$logoExt = pathinfo($logo['url'], PATHINFO_EXTENSION);
?>

<?php if($logo): ?>
    <a href="<?php echo e(home_url('/')); ?>" class="<?php echo e($attributes->get('class')); ?>" title="<?php echo $siteName; ?>">
        <picture>
            <?php if($logoWebp): ?>
                <source srcset="<?php echo e($logoWebp['url']); ?>" type="image/webp">
            <?php endif; ?>
            <source srcset="<?php echo e($logo['url']); ?>" type="image/<?php echo e($logoExt); ?>">
            <img src=" <?php echo e($logo['url']); ?> " alt="<?php (bloginfo('name')); ?>" title="<?php (bloginfo('name')); ?>">
        </picture>
    </a>
<?php endif; ?>
<?php /**PATH /var/www/vhosts/jacobsandjacobs.net/httpdocs/resources/views/components/logo.blade.php ENDPATH**/ ?>