<?php if (have_rows('attorneys')) : ?>
    <div class="bg-oyster100 pb-20 lg:pb-40">
        <div class="container lg:max-w-[1000px]">
            <div class="grid md:grid-cols-2 gap-8">
                <?php if (have_rows('attorneys')) : ?><?php while (have_rows('attorneys')) : the_row(); ?>
                    <?php if(get_sub_field('page_link')): ?>
                        <a href="<?php echo get_sub_field('page_link'); ?>" class="block group relative rounded-2xl overflow-hidden" title="<?php echo get_sub_field('name'); ?>">
                            <?php if(get_sub_field('image')): ?>
                                <picture>
                                    <source srcset="<?php echo get_sub_field('image_webp')['url']; ?>" type="image/webp">
                                    <source srcset="<?php echo get_sub_field('image')['url']; ?>" type="image/<?php echo e(pathinfo(asset(get_sub_field('image')['url']), PATHINFO_EXTENSION)); ?>">
                                    <img src="<?php echo get_sub_field('image')['url']; ?>" alt="<?php echo get_sub_field('name'); ?> Headshot" title="<?php echo get_sub_field('name'); ?>" class="object-cover object-top md:object-center w-full group-hover:scale-105 transition-all">
                                </picture>
                            <?php else: ?>
                                <img src="<?= \Roots\asset('images/backgrounds/attorney-placeholder.svg'); ?>" alt="Image Placeholder" title="<?php echo get_sub_field('name'); ?>" class="object-cover object-top md:object-center w-full group-hover:scale-105 transition-all">
                            <?php endif; ?>
                            <?php if (get_sub_field('name')) : ?>
                                <div class="absolute bottom-0 left-0 w-full p-6 pb-8 [border-top:1px_solid_rgba(240,238,227,0.30)] text-white bg-[rgba(240,238,227,0.10)] backdrop-blur-md group-hover:bg-white group-hover:text-blue950 transition-all">
                                    <h2 class="h3 mb-4 flex items-center justify-between gap-2">
                                        <?php echo get_sub_field('name'); ?> 
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                            <path class="group-hover:fill-blue600" d="M19.125 6V15.75C19.125 16.0484 19.0065 16.3345 18.7955 16.5455C18.5845 16.7565 18.2984 16.875 18 16.875C17.7017 16.875 17.4155 16.7565 17.2045 16.5455C16.9935 16.3345 16.875 16.0484 16.875 15.75V8.71875L6.79596 18.7959C6.58461 19.0073 6.29797 19.126 5.99908 19.126C5.7002 19.126 5.41355 19.0073 5.20221 18.7959C4.99086 18.5846 4.87213 18.2979 4.87213 17.9991C4.87213 17.7002 4.99086 17.4135 5.20221 17.2022L15.2813 7.125H8.25002C7.95165 7.125 7.6655 7.00647 7.45452 6.7955C7.24355 6.58452 7.12502 6.29837 7.12502 6C7.12502 5.70163 7.24355 5.41548 7.45452 5.2045C7.6655 4.99353 7.95165 4.875 8.25002 4.875H18C18.2984 4.875 18.5845 4.99353 18.7955 5.2045C19.0065 5.41548 19.125 5.70163 19.125 6Z" fill="currentColor"/>
                                        </svg>
                                    </h2>
                                    <p class="mb-1 text-lg font-medium"><?php echo get_sub_field('designation'); ?></p>
                                    <p class="font-medium"><?php echo get_sub_field('description'); ?></p>
                                </div>
                            <?php endif; ?>
                        </a>
                    <?php else: ?> 
                        <div class="relative rounded-2xl overflow-hidden">
                            <?php if(get_sub_field('image')): ?>
                                <picture>
                                    <source srcset="<?php echo get_sub_field('image_webp')['url']; ?>" type="image/webp">
                                    <source srcset="<?php echo get_sub_field('image')['url']; ?>" type="image/<?php echo e(pathinfo(asset(get_sub_field('image')['url']), PATHINFO_EXTENSION)); ?>">
                                    <img src="<?php echo get_sub_field('image')['url']; ?>" alt="<?php echo get_sub_field('name'); ?> Headshot" title="<?php echo get_sub_field('name'); ?>" class="object-cover object-top md:object-center w-full group-hover:scale-105 transition-all">
                                </picture>
                            <?php else: ?>
                                <img src="<?= \Roots\asset('images/backgrounds/attorney-placeholder.svg'); ?>" alt="Image Placeholder" title="<?php echo get_sub_field('name'); ?>" class="object-cover object-top md:object-center w-full group-hover:scale-105 transition-all">
                            <?php endif; ?>
                            <?php if (get_sub_field('name')) : ?>
                                <div class="absolute bottom-0 left-0 w-full p-6 pb-8 [border-top:1px_solid_rgba(240,238,227,0.30)] text-white bg-[rgba(240,238,227,0.10)] backdrop-blur-md">
                                    <h2 class="h3 mb-4"><?php echo get_sub_field('name'); ?></h2>
                                    <p class="mb-1 text-lg font-medium"><?php echo get_sub_field('designation'); ?></p>
                                    <p class="font-medium"><?php echo get_sub_field('description'); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php endwhile; endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH /Users/ihfaz/Sites/jacobsandjacobs/resources/views/sections/attorney/archive.blade.php ENDPATH**/ ?>