<?php $homepage_id = get_option('page_on_front'); ?>

<?php if(have_rows('locations', $homepage_id)): ?>

    <section class="bg-oyster100 max-lg:pb-20">
        <div class="container">
            <h2 class="pre-head mb-2 lg:mb-7 text-center">Locations We Serve</h2>
            <p class="h1 mb-7 lg:mb-20 text-center">Proudly Serving <span class="italic font-libre">Washington</span> State</p>
            <div class="grid lg:grid-cols-[384px_1fr] lg:gap-13">
                <div class="space-y-4 lg:pb-20 xl:pb-40">
                    <?php while(have_rows('locations', $homepage_id)): ?> <?php the_row(); ?>
                        <?php if(get_sub_field('page_url')): ?>
                            <a href="<?php echo get_sub_field('page_url'); ?>" class="group flex items-center gap-7 bg-white border border-oyster200 rounded-2xl p-5 lg:p-6">
                                <div class="relative w-12 h-12 flex items-center justify-center rounded-full border border-oyster200">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="absolute left-[50%] translate-x-[-50%] opacity-0 group-hover:opacity-100 transition-all" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M12 1.87695C9.81273 1.87943 7.71575 2.74943 6.16911 4.29606C4.62247 5.8427 3.75248 7.93968 3.75 10.127C3.75 17.1863 11.25 22.5179 11.5697 22.741C11.6958 22.8294 11.846 22.8767 12 22.8767C12.154 22.8767 12.3042 22.8294 12.4303 22.741C12.75 22.5179 20.25 17.1863 20.25 10.127C20.2475 7.93968 19.3775 5.8427 17.8309 4.29606C16.2843 2.74943 14.1873 1.87943 12 1.87695ZM12 7.12695C12.5933 7.12695 13.1734 7.3029 13.6667 7.63254C14.1601 7.96219 14.5446 8.43072 14.7716 8.9789C14.9987 9.52708 15.0581 10.1303 14.9424 10.7122C14.8266 11.2942 14.5409 11.8287 14.1213 12.2483C13.7018 12.6678 13.1672 12.9536 12.5853 13.0693C12.0033 13.1851 11.4001 13.1257 10.8519 12.8986C10.3038 12.6715 9.83524 12.287 9.50559 11.7937C9.17595 11.3003 9 10.7203 9 10.127C9 9.3313 9.31607 8.56824 9.87868 8.00563C10.4413 7.44302 11.2044 7.12695 12 7.12695Z" fill="#9F3531"/>
                                    </svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M12 6.37695C11.2583 6.37695 10.5333 6.59689 9.91661 7.00894C9.29993 7.421 8.81928 8.00667 8.53545 8.69189C8.25162 9.37711 8.17736 10.1311 8.32205 10.8585C8.46675 11.586 8.8239 12.2542 9.34835 12.7786C9.8728 13.3031 10.541 13.6602 11.2684 13.8049C11.9958 13.9496 12.7498 13.8753 13.4351 13.5915C14.1203 13.3077 14.706 12.827 15.118 12.2103C15.5301 11.5937 15.75 10.8686 15.75 10.127C15.75 9.13239 15.3549 8.17856 14.6517 7.4753C13.9484 6.77204 12.9946 6.37695 12 6.37695ZM12 12.377C11.555 12.377 11.12 12.245 10.75 11.9978C10.38 11.7505 10.0916 11.3991 9.92127 10.988C9.75097 10.5769 9.70642 10.1245 9.79323 9.688C9.88005 9.25154 10.0943 8.85063 10.409 8.53596C10.7237 8.22129 11.1246 8.007 11.561 7.92019C11.9975 7.83337 12.4499 7.87793 12.861 8.04822C13.2722 8.21852 13.6236 8.50691 13.8708 8.87692C14.118 9.24693 14.25 9.68195 14.25 10.127C14.25 10.7237 14.0129 11.296 13.591 11.7179C13.169 12.1399 12.5967 12.377 12 12.377ZM12 1.87695C9.81273 1.87943 7.71575 2.74943 6.16911 4.29606C4.62247 5.8427 3.75248 7.93968 3.75 10.127C3.75 13.0707 5.11031 16.1907 7.6875 19.1504C8.84552 20.4878 10.1489 21.6921 11.5734 22.741C11.6995 22.8294 11.8498 22.8767 12.0037 22.8767C12.1577 22.8767 12.308 22.8294 12.4341 22.741C13.856 21.6917 15.1568 20.4874 16.3125 19.1504C18.8859 16.1907 20.25 13.0707 20.25 10.127C20.2475 7.93968 19.3775 5.8427 17.8309 4.29606C16.2843 2.74943 14.1873 1.87943 12 1.87695ZM12 21.1895C10.4503 19.9707 5.25 15.4941 5.25 10.127C5.25 8.33674 5.96116 6.61985 7.22703 5.35398C8.4929 4.08811 10.2098 3.37695 12 3.37695C13.7902 3.37695 15.5071 4.08811 16.773 5.35398C18.0388 6.61985 18.75 8.33674 18.75 10.127C18.75 15.4923 13.5497 19.9707 12 21.1895Z" fill="#9F3531"/>
                                    </svg>
                                </div>
                                <h3 class="h4"><?php echo get_sub_field('title'); ?></h3>
                            </a>
                        <?php else: ?> 
                            <div class="group flex items-center gap-7 bg-white border border-oyster200 rounded-2xl p-5 lg:p-6">
                                <div class="w-12 h-12 flex items-center justify-center rounded-full border border-oyster200">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M12 6.37695C11.2583 6.37695 10.5333 6.59689 9.91661 7.00894C9.29993 7.421 8.81928 8.00667 8.53545 8.69189C8.25162 9.37711 8.17736 10.1311 8.32205 10.8585C8.46675 11.586 8.8239 12.2542 9.34835 12.7786C9.8728 13.3031 10.541 13.6602 11.2684 13.8049C11.9958 13.9496 12.7498 13.8753 13.4351 13.5915C14.1203 13.3077 14.706 12.827 15.118 12.2103C15.5301 11.5937 15.75 10.8686 15.75 10.127C15.75 9.13239 15.3549 8.17856 14.6517 7.4753C13.9484 6.77204 12.9946 6.37695 12 6.37695ZM12 12.377C11.555 12.377 11.12 12.245 10.75 11.9978C10.38 11.7505 10.0916 11.3991 9.92127 10.988C9.75097 10.5769 9.70642 10.1245 9.79323 9.688C9.88005 9.25154 10.0943 8.85063 10.409 8.53596C10.7237 8.22129 11.1246 8.007 11.561 7.92019C11.9975 7.83337 12.4499 7.87793 12.861 8.04822C13.2722 8.21852 13.6236 8.50691 13.8708 8.87692C14.118 9.24693 14.25 9.68195 14.25 10.127C14.25 10.7237 14.0129 11.296 13.591 11.7179C13.169 12.1399 12.5967 12.377 12 12.377ZM12 1.87695C9.81273 1.87943 7.71575 2.74943 6.16911 4.29606C4.62247 5.8427 3.75248 7.93968 3.75 10.127C3.75 13.0707 5.11031 16.1907 7.6875 19.1504C8.84552 20.4878 10.1489 21.6921 11.5734 22.741C11.6995 22.8294 11.8498 22.8767 12.0037 22.8767C12.1577 22.8767 12.308 22.8294 12.4341 22.741C13.856 21.6917 15.1568 20.4874 16.3125 19.1504C18.8859 16.1907 20.25 13.0707 20.25 10.127C20.2475 7.93968 19.3775 5.8427 17.8309 4.29606C16.2843 2.74943 14.1873 1.87943 12 1.87695ZM12 21.1895C10.4503 19.9707 5.25 15.4941 5.25 10.127C5.25 8.33674 5.96116 6.61985 7.22703 5.35398C8.4929 4.08811 10.2098 3.37695 12 3.37695C13.7902 3.37695 15.5071 4.08811 16.773 5.35398C18.0388 6.61985 18.75 8.33674 18.75 10.127C18.75 15.4923 13.5497 19.9707 12 21.1895Z" fill="#9F3531"/>
                                    </svg>
                                </div>
                                <h3 class="h4"><?php echo get_sub_field('title'); ?></h3>
                            </div>
                        <?php endif; ?>
                    <?php endwhile; ?>
                </div>
                <div class="bg-map bg-top [background-size:100%_auto] bg-no-repeat max-lg:hidden"></div>
            </div>
        </div>
    </section>

<?php endif; ?><?php /**PATH /var/www/vhosts/jacobsandjacobs.net/httpdocs/resources/views/sections/homepage/locations-served.blade.php ENDPATH**/ ?>