<section class="pb-16 md:pb-20 lg:pb-52">
    <div class="container">
        <div class="mb-8 md:mb-12 lg:mb-24">
            <?php if(has_post_thumbnail()): ?>
                <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'large'); ?>" alt="Featured Image for the Blog Post" class="w-full h-[300px] lg:h-[500px] object-cover object-center bg-gray-200" title="Featured Image for - <?php echo get_the_title(); ?>" loading="lazy">
            <?php else: ?>
                <div class="flex items-center justify-center w-full h-[300px] md:h-[500px] bg-gray-200">
                    <img src="<?= \Roots\asset('images/cas-logo.svg'); ?>" alt="Coastal Auto Shipping Logo" class="max-w-[200px] md:max-w-[300px] grayscale opacity-20" title="Coastal Auto Shipping" loading="lazy" class="w-full h-full object-cover object-center">
                </div>
            <?php endif; ?>
        </div>
        <article class="main-content grid lg:grid-cols-[300px_1fr] gap-8">
            <div>
                <?php echo $__env->make('partials.table-of-contents', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div>
                <?php the_content(); ?>
                <a href="/blog/" class="flex items-center justify-center gap-3 rounded-2xl px-5 py-3 border-2 border-blue-50 font-semibold w-fit !no-underline hover:border-orange-600 hover:!text-navy-950 transition-all mt-10 lg:mt-14" title="Call Us">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                        <path d="M13.1625 15.5866C13.3386 15.7627 13.4375 16.0016 13.4375 16.2507C13.4375 16.4997 13.3386 16.7386 13.1625 16.9147C12.9863 17.0908 12.7475 17.1898 12.4984 17.1898C12.2493 17.1898 12.0105 17.0908 11.8343 16.9147L5.58433 10.6647C5.49693 10.5776 5.42759 10.4741 5.38027 10.3602C5.33295 10.2462 5.30859 10.124 5.30859 10.0006C5.30859 9.87726 5.33295 9.75509 5.38027 9.64113C5.42759 9.52718 5.49693 9.42368 5.58433 9.33659L11.8343 3.08659C12.0105 2.91047 12.2493 2.81152 12.4984 2.81152C12.7475 2.81152 12.9863 2.91047 13.1625 3.08659C13.3386 3.26271 13.4375 3.50158 13.4375 3.75065C13.4375 3.99972 13.3386 4.23859 13.1625 4.41471L7.5773 9.99987L13.1625 15.5866Z" fill="#03162A"/>
                    </svg>
                    Back to Blog
                </a>
            </div>
        </article>
    </div>
</section>
<?php echo $__env->make('sections.single.related-posts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/sections/single/content.blade.php ENDPATH**/ ?>