<?php $homepage_id = get_option('page_on_front'); ?>

<?php if(have_rows('practice_areas', $homepage_id)): ?>
    <section class="bg-oyster100 py-20 lg:py-40">
        <div class="container">
            <p class="pre-head text-center mb-2 lg:mb-7">Practice Areas</p>
            <h2 class="h1 text-center lg:max-w-[996px] lg:mx-auto">Types of <span class="font-libre italic">Personal Injury Cases</span> We Handle in Washington State</h2>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-5 mt-10 lg:mt-20">
                <?php while(have_rows('practice_areas', $homepage_id)): ?> <?php the_row(); ?>
                    <div class="bg-white rounded-2xl border-oyster200 space-y-5 p-5 lg:p-8">
                        <div class="flex items-center justify-center rounded-full bg-frame bg-no-repeat bg-contain h-17.5 w-16.25">
                            <?php echo get_sub_field('svg_icon'); ?>

                        </div>
                        <?php if(get_sub_field('page_url')): ?>
                            <a href="<?php echo e(get_sub_field('page_url')); ?>" title="Click to Learn More" class="inline-block">
                                <h3 class="h4 hover:text-red700 transition-all"><?php echo e(get_sub_field('title')); ?></h3>
                            </a>
                        <?php else: ?> 
                            <h3 class="h4"><?php echo e(get_sub_field('title')); ?></h3>
                        <?php endif; ?>
                        <p class="text-dgrey line-clamp-2"><?php echo e(get_sub_field('description')); ?></p>
                        <?php if(get_sub_field('page_url')): ?>
                            <a href="<?php echo e(get_sub_field('page_url')); ?>" class="flex items-center gap-3 font-semibold tracking-[.32px] text-blue700 hover:text-red700 transition-all" title="Click to Learn More">
                                View Service
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                    <path d="M17.5383 10.9389L11.9133 16.5639C11.7372 16.7401 11.4983 16.839 11.2492 16.839C11.0001 16.839 10.7613 16.7401 10.5852 16.5639C10.409 16.3878 10.3101 16.1489 10.3101 15.8999C10.3101 15.6508 10.409 15.4119 10.5852 15.2358L14.6094 11.2132H3.125C2.87636 11.2132 2.6379 11.1144 2.46209 10.9386C2.28627 10.7627 2.1875 10.5243 2.1875 10.2757C2.1875 10.027 2.28627 9.78855 2.46209 9.61274C2.6379 9.43692 2.87636 9.33815 3.125 9.33815H14.6094L10.5867 5.31315C10.4106 5.13703 10.3117 4.89816 10.3117 4.64909C10.3117 4.40002 10.4106 4.16114 10.5867 3.98502C10.7628 3.8089 11.0017 3.70996 11.2508 3.70996C11.4999 3.70996 11.7387 3.8089 11.9148 3.98502L17.5398 9.61002C17.6273 9.69724 17.6966 9.80086 17.7438 9.91495C17.7911 10.029 17.8153 10.1513 17.8152 10.2748C17.815 10.3983 17.7905 10.5205 17.743 10.6345C17.6955 10.7485 17.6259 10.8519 17.5383 10.9389Z" fill="currentColor"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endwhile; ?>
                <div class="p-5 lg:p-8">
                    <h3 class="mb-4">We Handle It All, So You Don't Have To</h3>
                    <p class="mb-5">From car accidents to slip and falls, we fight for maximum compensation in every case. No fees unless we win!</p>
                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => ['href' => ''.e(get_the_permalink(316)).'','type' => 'primary','title' => 'Get Your Free Consultation']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['href' => ''.e(get_the_permalink(316)).'','type' => 'primary','title' => 'Get Your Free Consultation']); ?>Get Your Free Consultation <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?><?php /**PATH /home/jacobsandjacobs/public_html/resources/views/sections/homepage/practice-areas.blade.php ENDPATH**/ ?>