<section class="bg-oyster100 py-20 lg:py-40 event-info">
    <div class="container">
        <div class="grid lg:grid-cols-2 gap-8 items-center">
            <div>
                <?php if(has_post_thumbnail()): ?>
                    <img src="<?php echo e(get_the_post_thumbnail_url(null, 'large')); ?>" alt="<?php echo e(get_the_title()); ?>" class="max-lg:max-w-550 w-full" alt="Event Banner" title="<?php echo get_the_title(); ?>" loading="lazy">
                <?php else: ?>
                    <img src="<?= \Roots\asset('images/backgrounds/blog-placeholder.svg'); ?>" class="max-lg:max-w-550 w-full" alt="Featured Image Placeholder" title="Featured Image for - <?php echo get_the_title(); ?>" loading="lazy">
                <?php endif; ?>
            </div>
            <div class="lg:pl-14 space-y-7 lg:space-y-10">
                <h1 class="h2"><?php echo get_the_title(); ?></h1>
                <div class="space-y-7">
                    <?php the_content(); ?>
                </div>
                <?php if (get_field('event_date_and_time')) : ?>
                    <div>
                        <p class="font-medium text-xl text-oyster800">When</p>
                        <p class="h4"><?php echo get_field('event_date_and_time'); ?></p>
                    </div>
                <?php endif; ?>
                <?php if (get_field('event_venue')) : ?>
                    <div>
                        <p class="font-medium text-xl text-oyster800">Where</p>
                        <div class="text-lg">
                            <?php echo get_field('event_venue'); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (get_field('event_schedule')) : ?>
                    <div>
                        <p class="font-medium text-xl text-oyster800">Event Schedule</p>
                        <div class="text-lg">
                            <?php echo get_field('event_schedule'); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (get_field('deadline')) : ?>
                    <p class="text-red700 font-medium"><?php echo get_field('deadline'); ?></p>
                <?php endif; ?>
                <?php if (get_field('registration_url')) : ?>
                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => ['href' => ''.e(get_field('registration_url')).'','title' => 'Click to Register','target' => '_blank']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['href' => ''.e(get_field('registration_url')).'','title' => 'Click to Register','target' => '_blank']); ?>Click Here to Register <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section><?php /**PATH /home/jacobsandjacobs/public_html/resources/views/sections/events/content.blade.php ENDPATH**/ ?>