<!-- Step 1: Shipping Route Details -->
<div class="max-w-[400px]">
    <!-- Transport From Section -->
    <div class="mb-8">
        <label class="block font-medium mb-1.5">Transport From</label>
        
        <!-- Toggle Buttons -->
        <div class="flex w-fit rounded-full border border-gray-300 p-1 mb-4">
            <button 
                type="button"
                @click="model.origin_mode = 'city'"
                :class="model.origin_mode === 'city' 
                    ? 'bg-orange-600 text-white' 
                    : 'bg-white text-gray-700 border border-transparent'"
                class="px-4 py-2 rounded-full font-medium transition-colors duration-200"
            >
                City / ZIP
            </button>
            <button 
                type="button"
                @click="model.origin_mode = 'port'"
                :class="model.origin_mode === 'port' 
                    ? 'bg-orange-600 text-white' 
                    : 'bg-white text-gray-700 border border-transparent'"
                class="px-4 py-2 rounded-full font-medium transition-colors duration-200"
            >
                Port
            </button>
        </div>
        
        <div class="h-16 relative">
            <!-- City/ZIP Input Field -->
            <div 
                x-show="model.origin_mode === 'city'" 
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform translate-y-2"
                x-transition:enter-end="opacity-100 transform translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 transform translate-y-0"
                x-transition:leave-end="opacity-0 transform -translate-y-2"
                class="absolute inset-0"
            >
                <div 
                    x-data="placesAutocomplete('from_city_zip')"
                    @place-selected="$parent.model[$event.detail.field] = $event.detail.value"
                    class="relative"
                >
                    <input 
                        type="text" 
                        x-model="model.from_city_zip"
                        x-ref="input"
                        placeholder="e.g., Los Angeles, 90001"
                        :class="errors.from_city_zip ? 'border-red-500 focus:ring-red-500' : 'border-gray-200 focus:ring-orange-500'"
                        class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:border-transparent placeholder-gray-400"
                        @input="handleInput($event)"
                        @focus="showSuggestions = true"
                        @blur="setTimeout(() => showSuggestions = false, 200)"
                    >
                    
                    <!-- Autocomplete Suggestions -->
                    <div 
                        x-show="showSuggestions && suggestions.length > 0"
                        class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 overflow-auto focus:outline-none"
                    >
                        <template x-for="(suggestion, index) in suggestions" :key="index">
                            <div 
                                @click="selectSuggestion(suggestion)"
                                class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900 text-gray-900"
                            >
                                <span x-text="formatSuggestionDisplay(suggestion)" class="block truncate"></span>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
            
            <!-- Port Dropdown Field -->
            <div 
                x-show="model.origin_mode === 'port'" 
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform translate-y-2"
                x-transition:enter-end="opacity-100 transform translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 transform translate-y-0"
                x-transition:leave-end="opacity-0 transform -translate-y-2"
                class="absolute inset-0"
            >
                <div 
                    x-data="select2" 
                    x-init="
                        options = portOptions || []; 
                        // set initial selection from model
                        selected = (options || []).find(opt => opt.value === model.from_city_zip) || null;
                        $watch('portOptions', (newOptions) => { 
                            options = newOptions || []; 
                            // re-evaluate selection when options refresh
                            selected = (options || []).find(opt => opt.value === model.from_city_zip) || selected;
                        });
                        $watch('model.from_city_zip', (newValue) => { 
                            if (!newValue) { 
                                selected = null; 
                            } else {
                                selected = options.find(opt => opt.value === newValue) || null;
                            }
                        });
                    "
                    @select="handlePortSelect($event, 'from')"
                    class="relative"
                >
                    <!-- Select2 Trigger -->
                    <div 
                        @click="toggle()"
                        :class="errors.from_city_zip ? 'border-red-500' : 'border-gray-200'"
                        class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent cursor-pointer flex items-center justify-between"
                    >
                        <span x-text="selected ? selected.label : 'Please select a port'" class="text-gray-700"></span>
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>

                    <!-- Select2 Dropdown -->
                    <div 
                        x-show="open"
                        @click.away="close()"
                        x-transition:enter="transition ease-out duration-100"
                        x-transition:enter-start="transform opacity-0 scale-95"
                        x-transition:enter-end="transform opacity-100 scale-100"
                        x-transition:leave="transition ease-in duration-75"
                        x-transition:leave-start="transform opacity-100 scale-100"
                        x-transition:leave-end="transform opacity-0 scale-95"
                        class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 focus:outline-none flex flex-col"
                    >
                        <!-- Search Input - Sticky at top -->
                        <div class="px-3 py-2 border-b border-gray-200 bg-white sticky top-0 z-10">
                            <input 
                                x-ref="search"
                                x-model="search"
                                type="text"
                                placeholder="Search ports..."
                                class="w-full px-2 py-1 text-sm border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-orange-500"
                            />
                        </div>
                        
                        <!-- Scrollable Options Container -->
                        <div class="overflow-auto flex-1">
                            <!-- Options -->
                            <template x-for="option in filteredOptions" :key="option.value">
                                <div 
                                    @click="select(option)"
                                    class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900"
                                    :class="selected && selected.value === option.value ? 'bg-orange-100 text-orange-900' : 'text-gray-900'"
                                >
                                    <span x-text="option.label" class="block truncate"></span>
                                    <span 
                                        x-show="selected && selected.value === option.value"
                                        class="absolute inset-y-0 right-0 flex items-center pr-4"
                                    >
                                        <svg class="h-5 w-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                    </span>
                                </div>
                            </template>
                            
                            <!-- No Results -->
                            <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-sm text-gray-500">
                                No ports found
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Error Message -->
        <div x-show="errors.from_city_zip" class="mt-2 text-sm text-red-600" x-text="errors.from_city_zip"></div>
    </div>
  
    <!-- Transport To Section -->
    <div class="mb-8">
        <label class="block font-medium mb-1.5">Transport To</label>
        
        <!-- Toggle Buttons -->
        <div class="flex w-fit rounded-full border border-gray-300 p-1 mb-4">
            <button 
                type="button"
                @click="model.dest_mode = 'city'"
                :class="model.dest_mode === 'city' 
                    ? 'bg-orange-600 text-white' 
                    : 'bg-white text-gray-700 border border-transparent'"
                class="px-4 py-2 rounded-full font-medium transition-colors duration-200"
            >
                City / ZIP
            </button>
            <button 
                type="button"
                @click="model.dest_mode = 'port'"
                :class="model.dest_mode === 'port' 
                    ? 'bg-orange-600 text-white' 
                    : 'bg-white text-gray-700 border border-transparent'"
                class="px-4 py-2 rounded-full font-medium transition-colors duration-200"
            >
                Port
            </button>
        </div>
        
        <div class="h-16 relative">
            <!-- City/ZIP Input Field -->
            <div 
                x-show="model.dest_mode === 'city'" 
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform translate-y-2"
                x-transition:enter-end="opacity-100 transform translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 transform translate-y-0"
                x-transition:leave-end="opacity-0 transform -translate-y-2"
                class="absolute inset-0"
            >
                <div 
                    x-data="placesAutocomplete('to_city_zip')"
                    @place-selected="$parent.model[$event.detail.field] = $event.detail.value"
                    class="relative"
                >
                    <input 
                        type="text" 
                        x-model="model.to_city_zip"
                        x-ref="input"
                        placeholder="e.g., Miami, 33101"
                        :class="errors.to_city_zip ? 'border-red-500 focus:ring-red-500' : 'border-gray-200 focus:ring-orange-500'"
                        class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:border-transparent placeholder-gray-400"
                        @input="handleInput($event)"
                        @focus="showSuggestions = true"
                        @blur="setTimeout(() => showSuggestions = false, 200)"
                    >
                    
                    <!-- Autocomplete Suggestions -->
                    <div 
                        x-show="showSuggestions && suggestions.length > 0"
                        class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 overflow-auto focus:outline-none"
                    >
                        <template x-for="(suggestion, index) in suggestions" :key="index">
                            <div 
                                @click="selectSuggestion(suggestion)"
                                class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900 text-gray-900"
                            >
                                <span x-text="formatSuggestionDisplay(suggestion)" class="block truncate"></span>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
            
            <!-- Port Dropdown Field -->
            <div 
                x-show="model.dest_mode === 'port'" 
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform translate-y-2"
                x-transition:enter-end="opacity-100 transform translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 transform translate-y-0"
                x-transition:leave-end="opacity-0 transform -translate-y-2"
                class="absolute inset-0"
            >
                <div 
                    x-data="select2" 
                    x-init="
                        options = portOptions || []; 
                        // set initial selection from model
                        selected = (options || []).find(opt => opt.value === model.dest_port) || null;
                        $watch('portOptions', (newOptions) => { 
                            options = newOptions || []; 
                            selected = (options || []).find(opt => opt.value === model.dest_port) || selected;
                        });
                        $watch('model.dest_port', (newValue) => { 
                            if (!newValue) { 
                                selected = null; 
                            } else {
                                selected = options.find(opt => opt.value === newValue) || null;
                            }
                        });
                    "
                    @select="handlePortSelect($event, 'dest')"
                    class="relative"
                >
                    <!-- Select2 Trigger -->
                    <div 
                        @click="toggle()"
                        :class="errors.dest_port ? 'border-red-500' : 'border-gray-200'"
                        class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent cursor-pointer flex items-center justify-between"
                    >
                        <span x-text="selected ? selected.label : 'Please select a port'" class="text-gray-700"></span>
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>

                    <!-- Select2 Dropdown -->
                    <div 
                        x-show="open"
                        @click.away="close()"
                        x-transition:enter="transition ease-out duration-100"
                        x-transition:enter-start="transform opacity-0 scale-95"
                        x-transition:enter-end="transform opacity-100 scale-100"
                        x-transition:leave="transition ease-in duration-75"
                        x-transition:leave-start="transform opacity-100 scale-100"
                        x-transition:leave-end="transform opacity-0 scale-95"
                        class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 focus:outline-none flex flex-col"
                    >
                        <!-- Search Input - Sticky at top -->
                        <div class="px-3 py-2 border-b border-gray-200 bg-white sticky top-0 z-10">
                            <input 
                                x-ref="search"
                                x-model="search"
                                type="text"
                                placeholder="Search ports..."
                                class="w-full px-2 py-1 text-sm border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-orange-500"
                            />
                        </div>
                        
                        <!-- Scrollable Options Container -->
                        <div class="overflow-auto flex-1">
                            <!-- Options -->
                            <template x-for="option in filteredOptions" :key="option.value">
                                <div 
                                    @click="select(option)"
                                    class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900"
                                    :class="selected && selected.value === option.value ? 'bg-orange-100 text-orange-900' : 'text-gray-900'"
                                >
                                    <span x-text="option.label" class="block truncate"></span>
                                    <span 
                                        x-show="selected && selected.value === option.value"
                                        class="absolute inset-y-0 right-0 flex items-center pr-4"
                                    >
                                        <svg class="h-5 w-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                    </span>
                                </div>
                            </template>
                            
                            <!-- No Results -->
                            <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-sm text-gray-500">
                                No ports found
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Error Messages -->
        <div x-show="errors.to_city_zip" class="mt-2 text-sm text-red-600" x-text="errors.to_city_zip"></div>
        <div x-show="errors.dest_port" class="mt-2 text-sm text-red-600" x-text="errors.dest_port"></div>
    </div>
  
    <button 
        @click="next()"
        :disabled="busy"
        class="w-fit primary-button disabled:opacity-50 disabled:cursor-not-allowed flex items-center justify-center gap-3"
    >
        <span x-text="busy ? 'Processing...' : 'Next - Vehicle Details'"></span>
        <?php if (isset($component)) { $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e = $component; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icon-next'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['x-show' => '!busy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e)): ?>
<?php $component = $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e; ?>
<?php unset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e); ?>
<?php endif; ?>
    </button>
</div><?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/quote/steps/_route.blade.php ENDPATH**/ ?>