<?php
    $isOpen = filter_var($open ?? false, FILTER_VALIDATE_BOOLEAN);
    $questionContent = isset($question) ? trim((string) $question) : ($attributes->get('question') ?? 'Frequently Asked Question');
    $answerContent = isset($answer) ? (string) $answer : (string) ($slot ?? $attributes->get('answer', ''));
    $componentId = $attributes->get('id') ?? 'faq-' . (string) \Illuminate\Support\Str::uuid();
?>

<div
    x-data="{ open: <?php echo e($isOpen ? 'true' : 'false'); ?> }"
    x-id="['answer']"
    <?php echo e($attributes->merge(['class' => 'faq-alt-component'])); ?>

>
    <button
        type="button"
        @click="open = !open"
        :aria-expanded="open"
        aria-controls="<?php echo e($componentId); ?>"
        class="w-full flex items-center justify-between gap-4 py-3 focus:outline-none border-t border-gray-200"
    >
        <?php if (isset($component)) { $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e = $component; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icon-info'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-0.5']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e)): ?>
<?php $component = $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e; ?>
<?php unset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e); ?>
<?php endif; ?>
        <span class="font-medium w-full text-left"><?php echo e($questionContent); ?></span>
        <svg
            class="w-5 h-5 text-gray-500 transition-transform duration-300"
            :class="{ 'rotate-180': open }"
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
        >
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <div
        id="<?php echo e($componentId); ?>"
        x-ref="content"
        x-effect="$el.style.maxHeight = open ? $el.scrollHeight + 'px' : '0px'"
        class="overflow-hidden transition-all duration-300 ease-in-out"
    >
        <div class="px-8 pb-4 pt-0 text-gray-600 text-sm leading-relaxed">
            <?php echo e($answerContent); ?>

        </div>
    </div>
</div>

<?php /**PATH /home/otmdev/public_html/coastalautoshipping.otmdev.co/resources/views/components/faq-alt.blade.php ENDPATH**/ ?>