<?php
$services = [
    [
        'name' => 'Cars',
        'image' => 'bg-car'
    ],
    [
        'name' => 'Trucks',
        'image' => 'bg-truck'
    ],
    [
        'name' => 'SUVs',
        'image' => 'bg-suv'
    ],
    [
        'name' => 'Vans',
        'image' => 'bg-van'
    ],
    [
        'name' => 'Motorcycles',
        'image' => 'bg-motorcycle'
    ],
    [
        'name' => 'Limousines',
        'image' => 'bg-limo'
    ],
    [
        'name' => 'RVs',
        'image' => 'bg-rv'
    ],
    [
        'name' => 'Trailers',
        'image' => 'bg-trailer'
    ],
    [
        'name' => 'Boats',
        'image' => 'bg-boat'
    ],
    [
        'name' => 'Equipment',
        'image' => 'bg-equipment'
    ]
];
?>

<section class="py-16 md:py-20 lg:py-52 bg-light-gradient">
    <div class="container">
        <div class="text-center max-w-[786px] mx-auto">
            <p class="subheading mb-3">What We Offer</p>
            <h2 class="mb-6">What We Transport</h2>
            <p>With tailored strategies and expert insights, we help you achieve your financial goals with confidence.</p>
        </div>
        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-5 gap-4 md:gap-8 lg:gap-14 mt-9 lg:mt-20">
            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="text-center">
                    <div class="aspect-[1/1] max-w-[200px] mx-auto mb-2 md:mb-5 <?php echo e($service['image']); ?> bg-cover bg-center rounded-[48px] xl:rounded-[64px]"></div>
                    <h3 class="text-lg font-semibold text-navy-800"><?php echo e($service['name']); ?></h3>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section><?php /**PATH /home/otmdev/public_html/coastalautoshipping.otmdev.co/resources/views/sections/homepage/transportation-services.blade.php ENDPATH**/ ?>