<!-- Step 4: Summary -->
<div class="max-w-3xl mx-auto">
    <!-- Shipping Route Details -->
    <div class="mb-8">
        <h3 class="text-lg font-bold text-gray-900 mb-4">Shipping Route Details</h3>
        <div class="grid grid-cols-2 gap-6">
            <div>
                <div class="text-gray-600 mb-1">Transport From</div>
                <div class="font-bold text-gray-900" x-text="model.origin_mode === 'port' ? model.from_city_zip : model.from_city_zip"></div>
            </div>
            <div>
                <div class="text-gray-600 mb-1">Transport To</div>
                <div class="font-bold text-gray-900" x-text="model.dest_mode === 'port' ? model.dest_port : model.to_city_zip"></div>
            </div>
        </div>
    </div>

    <!-- Vehicle Details -->
    <div class="mb-8">
        <h3 class="text-lg font-bold text-gray-900 mb-4">Vehicle Details</h3>
        <div class="grid grid-cols-2 gap-6">
            <div>
                <div class="text-gray-600 mb-1">Vehicle Make</div>
                <div class="font-bold text-gray-900" x-text="model.vehicle_make"></div>
            </div>
            <div>
                <div class="text-gray-600 mb-1">Vehicle Model</div>
                <div class="font-bold text-gray-900" x-text="model.vehicle_model"></div>
            </div>
            <div>
                <div class="text-gray-600 mb-1">Vehicle Year</div>
                <div class="font-bold text-gray-900" x-text="model.vehicle_year"></div>
            </div>
            <div>
                <div class="text-gray-600 mb-1">Is the vehicle operable?</div>
                <div class="font-bold text-gray-900" x-text="model.operable ? 'Yes' : 'No'"></div>
            </div>
        </div>
    </div>

    <!-- Shipping Details & Contact Info -->
    <div class="mb-8">
        <h3 class="text-lg font-bold text-gray-900 mb-4">Shipping Details & Contact Info</h3>
        <div class="grid grid-cols-2 gap-6">
            <div>
                <div class="text-gray-600 mb-1">First Name</div>
                <div class="font-bold text-gray-900" x-text="model.first_name"></div>
            </div>
            <div>
                <div class="text-gray-600 mb-1">Email</div>
                <div class="font-bold text-gray-900" x-text="model.email"></div>
            </div>
            <div>
                <div class="text-gray-600 mb-1">Last Name</div>
                <div class="font-bold text-gray-900" x-text="model.last_name"></div>
            </div>
            <div>
                <div class="text-gray-600 mb-1">Phone</div>
                <div class="font-bold text-gray-900" x-text="model.phone"></div>
            </div>
            <div>
                <div class="text-gray-600 mb-1">Estimated Pickup Date</div>
                <div class="font-bold text-gray-900" x-text="model.pickup_date"></div>
            </div>
        </div>
    </div>

    <div class="mb-8 py-6 lg:py-10 border-t border-b border-gray-200">
        <div class="flex justify-between items-center">
            <h3 class="text-lg font-bold text-gray-900">Estimated Shipping Cost</h3>
            <div class="text-3xl font-bold text-gray-900">
                <span x-text="quotePrice.found ? quotePrice.formatted : 'Quote Pending'"></span>
            </div>
        </div>
        <div class="text-sm text-gray-500 mt-2" x-show="!quotePrice.found">
            <span x-text="quotePrice.message"></span>
        </div>
    </div>

    <p class="mb-10 lg:w-3/4">
        <span x-show="quotePrice.found">
            Please complete your payment to confirm your booking. If you have any questions or need assistance, feel free to 
            <a href="<?php echo get_permalink(198); ?>" class="text-orange-600 font-semibold">contact us</a>.
        </span>
        <span x-show="!quotePrice.found">
            Your quote will be sent to your email address. If you have any questions or need assistance, feel free to 
            <a href="<?php echo get_permalink(198); ?>" class="text-orange-600 font-semibold">contact us</a>.
        </span>
    </p>

    <div class="flex gap-4">
        <button
            @click="back()"
            class="w-fit outline-button flex items-center gap-3"
        >
        <?php if (isset($component)) { $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e = $component; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icon-back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e)): ?>
<?php $component = $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e; ?>
<?php unset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e); ?>
<?php endif; ?>
            Back – Make Changes
        </button>

        <button
            x-show="quotePrice.found"
            @click="next()"
            :disabled="busy"
            class="w-fit primary-button disabled:opacity-50 disabled:cursor-not-allowed"
        >
            <span x-text="busy ? 'Processing...' : 'Complete Your Booking'"></span>
        </button>
    </div>
</div>
<?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/quote/steps/_summary.blade.php ENDPATH**/ ?>