<!-- Step 3: Contact Details -->
<div class="max-w-2xl mx-auto">
    <!-- Contact Information Section -->
    <div class="mb-8">
        <h3 class="text-xl font-bold text-gray-900 mb-6">Contact Information</h3>
        
        <!-- Name Row -->
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mb-4">
            <!-- First Name -->
            <div>
                <label class="block font-medium mb-2">First Name</label>
                <input 
                    type="text" 
                    x-model="model.first_name"
                    placeholder="John"
                    :class="errors.first_name ? 'border-red-500 focus:ring-red-500' : 'border-gray-200 focus:ring-orange-500'"
                    class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:border-transparent placeholder-gray-400"
                >
                <div x-show="errors.first_name" class="mt-2 text-sm text-red-600" x-text="errors.first_name"></div>
            </div>

            <!-- Last Name -->
            <div>
                <label class="block font-medium mb-2">Last Name</label>
                <input 
                    type="text" 
                    x-model="model.last_name"
                    placeholder="Smith"
                    :class="errors.last_name ? 'border-red-500 focus:ring-red-500' : 'border-gray-200 focus:ring-orange-500'"
                    class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:border-transparent placeholder-gray-400"
                >
                <div x-show="errors.last_name" class="mt-2 text-sm text-red-600" x-text="errors.last_name"></div>
            </div>
        </div>

        <!-- Contact Row -->
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mb-6">
            <!-- Phone -->
            <div>
                <label class="block font-medium mb-2">Phone</label>
                <input 
                    type="tel" 
                    x-model="model.phone"
                    placeholder="(000) 000-0000"
                    :class="errors.phone ? 'border-red-500 focus:ring-red-500' : 'border-gray-200 focus:ring-orange-500'"
                    class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:border-transparent placeholder-gray-400"
                >
                <div x-show="errors.phone" class="mt-2 text-sm text-red-600" x-text="errors.phone"></div>
            </div>

            <!-- Email -->
            <div>
                <label class="block font-medium mb-2">Email</label>
                <input 
                    type="email" 
                    x-model="model.email"
                    placeholder="email@example.com"
                    :class="errors.email ? 'border-red-500 focus:ring-red-500' : 'border-gray-200 focus:ring-orange-500'"
                    class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:border-transparent placeholder-gray-400"
                >
                <div x-show="errors.email" class="mt-2 text-sm text-red-600" x-text="errors.email"></div>
            </div>
        </div>
    </div>

    <!-- Shipping Date Section -->
    <div class="mb-8">
        <h3 class="text-xl font-bold text-gray-900 mb-6">Shipping Date</h3>
        
        <!-- Estimated Drop-off Date -->
        <div class="mb-6">
            <label class="block font-medium mb-2">Estimated Drop-off Date</label>
            <div class="relative">
                <input 
                    type="date" 
                    x-model="model.pickup_date"
                    :min="new Date().toISOString().split('T')[0]"
                    @change="
                        const today = new Date().toISOString().split('T')[0];
                        if (model.pickup_date && model.pickup_date <= today) {
                            errors.pickup_date = 'Please select a future date';
                        } else {
                            delete errors.pickup_date;
                        }
                    "
                    :class="errors.pickup_date ? 'border-red-500 focus:ring-red-500' : 'border-gray-200 focus:ring-orange-500'"
                    class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:border-transparent"
                >
                <!-- Calendar Icon -->
                <div class="absolute right-4 top-1/2 transform -translate-y-1/2 pointer-events-none">
                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                </div>
            </div>
            <div x-show="errors.pickup_date" class="mt-2 text-sm text-red-600" x-text="errors.pickup_date"></div>
        </div>
    </div>

    <!-- Consent Checkbox -->
    <div class="mb-8">
        <div class="flex items-start space-x-3">
            <input 
                type="checkbox" 
                x-model="model.consent_sms"
                id="consent-sms"
                class="mt-1 h-4 w-4 text-orange-600 focus:ring-orange-500 border-gray-300 rounded"
            >
            <label for="consent-sms" class="text-sm text-gray-700 leading-relaxed">
                By checking this box, I consent to receive text messages related to shipping from Coastal Auto Shipping. You can reply STOP to opt-out at any time. Message and data rates may apply. Message frequency may vary, text HELP for assistance. For more information, please refer to our Privacy Policy, and SMS terms and Conditions on our website. Thank you!
            </label>
        </div>
        <div x-show="errors.consent_sms" class="mt-2 text-sm text-red-600" x-text="errors.consent_sms"></div>
    </div>

    <div class="flex gap-4">
        <button
            @click="back()"
            class="w-fit outline-button flex items-center gap-3"
        >
            <?php if (isset($component)) { $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e = $component; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icon-back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e)): ?>
<?php $component = $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e; ?>
<?php unset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e); ?>
<?php endif; ?>
            Back – Vehicle Details
        </button>

        <button
            @click="next()"
            :disabled="busy"
            class="w-fit primary-button flex items-center gap-3 disabled:opacity-50 disabled:cursor-not-allowed"
        >
            <span x-text="busy ? 'Processing...' : 'Get My Free Quote'"></span>
        </button>
    </div>
</div><?php /**PATH /home/otmdev/public_html/coastalautoshipping.otmdev.co/resources/views/quote/steps/_contact.blade.php ENDPATH**/ ?>