<!-- Step 2: Vehicle Details -->
<div class="w-fit">
    <!-- Vehicle Information Section -->
    <div class="mb-8">
        <p class="font-mplus text-xl font-bold lg:mb-12">Vehicle Details</p>

        <!-- Vehicle Year -->
        <div class="mb-4">
            <label class="block font-medium mb-2">Vehicle Year</label>
            <div 
                x-data="select2" 
                x-init="options = yearOptions || []; selected = (options || []).find(opt => opt.value === model.vehicle_year) || null; $watch('yearOptions', (newOptions) => { options = newOptions || []; selected = (options || []).find(opt => opt.value === model.vehicle_year) || selected; })"
                @select="handleYearSelect($event)"
                class="relative"
            >
                <!-- Select2 Trigger -->
                <div 
                    @click="toggle()"
                    :class="errors.vehicle_year ? 'border-red-500' : 'border-gray-200'"
                    class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent cursor-pointer flex items-center justify-between"
                >
                    <span x-text="selected ? selected.label : 'Select Vehicle Year'" class="text-gray-700"></span>
                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </div>

                <!-- Select2 Dropdown -->
                <div 
                    x-show="open"
                    @click.away="close()"
                    x-transition:enter="transition ease-out duration-100"
                    x-transition:enter-start="transform opacity-0 scale-95"
                    x-transition:enter-end="transform opacity-100 scale-100"
                    x-transition:leave="transition ease-in duration-75"
                    x-transition:leave-start="transform opacity-100 scale-100"
                    x-transition:leave-end="transform opacity-0 scale-95"
                    class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 focus:outline-none flex flex-col"
                >
                    <!-- Search Input - Sticky at top -->
                    <div class="px-3 py-2 border-b border-gray-200 bg-white sticky top-0 z-10">
                        <input 
                            x-ref="search"
                            x-model="search"
                            type="text"
                            placeholder="Search years..."
                            class="w-full px-2 py-1 text-sm border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-orange-500"
                        />
                    </div>
                    
                    <!-- Scrollable Options Container -->
                    <div class="overflow-auto flex-1">
                        <!-- Options -->
                        <template x-for="option in filteredOptions" :key="option.value">
                            <div 
                                @click="select(option)"
                                class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900"
                                :class="selected && selected.value === option.value ? 'bg-orange-100 text-orange-900' : 'text-gray-900'"
                            >
                                <span x-text="option.label" class="block truncate"></span>
                                <span 
                                    x-show="selected && selected.value === option.value"
                                    class="absolute inset-y-0 right-0 flex items-center pr-4"
                                >
                                    <svg class="h-5 w-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                </span>
                            </div>
                        </template>
                        
                        <!-- No Results -->
                        <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-sm text-gray-500">
                            No years found
                        </div>
                    </div>
                </div>
            </div>
            <div x-show="errors.vehicle_year" class="mt-2 text-sm text-red-600" x-text="errors.vehicle_year"></div>
            <div x-show="errors.vehicle_years" class="mt-2 text-sm text-red-600 flex items-center gap-2">
                <span x-text="errors.vehicle_years"></span>
                <button @click="loadVehicleYears()" :disabled="loadingYears" class="text-blue-600 hover:text-blue-800 underline disabled:opacity-50">
                    Retry
                </button>
            </div>
        </div>
        
        <!-- Vehicle Make -->
        <div class="mb-4">
            <label class="block font-medium mb-2">Vehicle Make</label>
            <div 
                x-data="select2" 
                x-init="
                    options = makeOptions || []; 
                    selected = (options || []).find(opt => opt.value === model.vehicle_make) || null;
                    $watch('makeOptions', (newOptions) => { options = newOptions || []; selected = (options || []).find(opt => opt.value === model.vehicle_make) || selected; });
                    $watch('model.vehicle_make', (newValue) => { selected = newValue ? options.find(opt => opt.value === newValue) || null : null; });
                "
                @select="handleMakeSelect($event)"
                class="relative"
            >
                <!-- Select2 Trigger -->
                <div 
                    @click="toggle()"
                    :disabled="!model.vehicle_year || loadingMakes"
                    :class="errors.vehicle_make ? 'border-red-500' : (!model.vehicle_year || loadingMakes) ? 'border-gray-200 bg-gray-100 cursor-not-allowed' : 'border-gray-200'"
                    class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent cursor-pointer flex items-center justify-between"
                >
                    <span x-text="selected ? selected.label : (!model.vehicle_year ? 'Select Year First' : (loadingMakes ? 'Loading Makes...' : 'Select Make'))" class="text-gray-700"></span>
                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </div>

                <!-- Select2 Dropdown -->
                <div 
                    x-show="open"
                    @click.away="close()"
                    x-transition:enter="transition ease-out duration-100"
                    x-transition:enter-start="transform opacity-0 scale-95"
                    x-transition:enter-end="transform opacity-100 scale-100"
                    x-transition:leave="transition ease-in duration-75"
                    x-transition:leave-start="transform opacity-100 scale-100"
                    x-transition:leave-end="transform opacity-0 scale-95"
                    class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 focus:outline-none flex flex-col"
                >
                    <!-- Search Input - Sticky at top -->
                    <div class="px-3 py-2 border-b border-gray-200 bg-white sticky top-0 z-10">
                        <input 
                            x-ref="search"
                            x-model="search"
                            type="text"
                            placeholder="Search makes..."
                            class="w-full px-2 py-1 text-sm border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-orange-500"
                        />
                    </div>
                    
                    <!-- Scrollable Options Container -->
                    <div class="overflow-auto flex-1">
                        <!-- Options -->
                        <template x-for="option in filteredOptions" :key="option.value">
                            <div 
                                @click="select(option)"
                                class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900"
                                :class="selected && selected.value === option.value ? 'bg-orange-100 text-orange-900' : 'text-gray-900'"
                            >
                                <span x-text="option.label" class="block truncate"></span>
                                <span 
                                    x-show="selected && selected.value === option.value"
                                    class="absolute inset-y-0 right-0 flex items-center pr-4"
                                >
                                    <svg class="h-5 w-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                </span>
                            </div>
                        </template>
                        
                        <!-- No Results -->
                        <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-sm text-gray-500">
                            No makes found
                        </div>
                    </div>
                </div>
            </div>
            <div x-show="errors.vehicle_make" class="mt-2 text-sm text-red-600" x-text="errors.vehicle_make"></div>
            <div x-show="errors.vehicle_makes" class="mt-2 text-sm text-red-600 flex items-center gap-2">
                <span x-text="errors.vehicle_makes"></span>
                <button @click="loadVehicleMakes(model.vehicle_year)" :disabled="loadingMakes || !model.vehicle_year" class="text-blue-600 hover:text-blue-800 underline disabled:opacity-50">
                    Retry
                </button>
            </div>
        </div>
        
        <!-- Vehicle Model -->
        <div class="mb-4">
            <label class="block font-medium mb-2">Vehicle Model</label>
            <div 
                x-data="select2" 
                x-init="
                    options = modelOptions || []; 
                    selected = (options || []).find(opt => opt.value === model.vehicle_model) || null;
                    $watch('modelOptions', (newOptions) => { options = newOptions || []; selected = (options || []).find(opt => opt.value === model.vehicle_model) || selected; });
                    $watch('model.vehicle_model', (newValue) => { selected = newValue ? options.find(opt => opt.value === newValue) || null : null; });
                "
                @select="handleModelSelect($event)"
                class="relative"
            >
                <!-- Select2 Trigger -->
                <div 
                    @click="toggle()"
                    :disabled="!model.vehicle_make || loadingModels"
                    :class="errors.vehicle_model ? 'border-red-500' : (!model.vehicle_make || loadingModels) ? 'border-gray-200 bg-gray-100 cursor-not-allowed' : 'border-gray-200'"
                    class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent cursor-pointer flex items-center justify-between"
                >
                    <span x-text="selected ? selected.label : (!model.vehicle_make ? 'Select Make First' : (loadingModels ? 'Loading Models...' : 'Select Model'))" class="text-gray-700"></span>
                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </div>

                <!-- Select2 Dropdown -->
                <div 
                    x-show="open"
                    @click.away="close()"
                    x-transition:enter="transition ease-out duration-100"
                    x-transition:enter-start="transform opacity-0 scale-95"
                    x-transition:enter-end="transform opacity-100 scale-100"
                    x-transition:leave="transition ease-in duration-75"
                    x-transition:leave-start="transform opacity-100 scale-100"
                    x-transition:leave-end="transform opacity-0 scale-95"
                    class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 focus:outline-none flex flex-col"
                >
                    <!-- Search Input - Sticky at top -->
                    <div class="px-3 py-2 border-b border-gray-200 bg-white sticky top-0 z-10">
                        <input 
                            x-ref="search"
                            x-model="search"
                            type="text"
                            placeholder="Search models..."
                            class="w-full px-2 py-1 text-sm border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-orange-500"
                        />
                    </div>
                    
                    <!-- Scrollable Options Container -->
                    <div class="overflow-auto flex-1">
                        <!-- Options -->
                        <template x-for="option in filteredOptions" :key="option.value">
                            <div 
                                @click="select(option)"
                                class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900"
                                :class="selected && selected.value === option.value ? 'bg-orange-100 text-orange-900' : 'text-gray-900'"
                            >
                                <span x-text="option.label" class="block truncate"></span>
                                <span 
                                    x-show="selected && selected.value === option.value"
                                    class="absolute inset-y-0 right-0 flex items-center pr-4"
                                >
                                    <svg class="h-5 w-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                </span>
                            </div>
                        </template>
                        
                        <!-- No Results -->
                        <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-sm text-gray-500">
                            No models found
                        </div>
                    </div>
                </div>
            </div>
            <div x-show="errors.vehicle_model" class="mt-2 text-sm text-red-600" x-text="errors.vehicle_model"></div>
            <div x-show="errors.vehicle_models" class="mt-2 text-sm text-red-600 flex items-center gap-2">
                <span x-text="errors.vehicle_models"></span>
                <button @click="loadVehicleModels(model.vehicle_year, model.vehicle_make)" :disabled="loadingModels || !model.vehicle_year || !model.vehicle_make" class="text-blue-600 hover:text-blue-800 underline disabled:opacity-50">
                    Retry
                </button>
            </div>
        </div>
        
        <!-- Vehicle Operable Toggle -->
        <div class="mb-6">
            <label class="block font-medium mb-2">Is the vehicle operable?</label>
            <div class="flex items-center space-x-3">
                <span class="text-sm text-gray-700">No</span>
                <button 
                    type="button"
                    @click="model.operable = !model.operable"
                    :class="model.operable ? 'bg-blue-600' : 'bg-gray-300'"
                    class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2"
                >
                    <span 
                        :class="model.operable ? 'translate-x-6' : 'translate-x-1'"
                        class="inline-block h-4 w-4 transform rounded-full bg-white transition duration-200 ease-in-out"
                    ></span>
                </button>
                <span class="text-sm text-gray-700">Yes</span>
            </div>
        </div>
    </div>
    
    <!-- Navigation Buttons -->
    <div class="flex gap-4 justify-start">
        <!-- Back Button -->
        <button 
            @click="back()"
            class="w-fit outline-button flex items-center gap-3"
        >
            <?php if (isset($component)) { $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e = $component; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icon-back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e)): ?>
<?php $component = $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e; ?>
<?php unset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e); ?>
<?php endif; ?>
            Back – Shipping Route
        </button>
        
        <!-- Next Button -->
        <button 
            @click="next()"
            :disabled="busy"
            class="w-fit primary-button flex items-center gap-3 disabled:opacity-50 disabled:cursor-not-allowed"
        >
            <span x-text="busy ? 'Processing...' : 'Next – Contact'"></span>
            <?php if (isset($component)) { $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e = $component; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icon-next'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['x-show' => '!busy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e)): ?>
<?php $component = $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e; ?>
<?php unset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e); ?>
<?php endif; ?>
        </button>
    </div>
</div>
<?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/quote/steps/_vehicle.blade.php ENDPATH**/ ?>