<section class="pb-16 md:pb-20 lg:pb-52">
    <div class="container">
        <h2 class="lg:text-5xl !leading-130 max-w-[800px] mx-auto text-center mb-9 lg:mb-20">Hawaii Car Transport <span class="whitespace-nowrap text-orange-600 pb-2 relative after:content-[''] after:absolute after:h-2 after:w-full after:bg-underline after:bottom-0 after:left-0 after:bg-no-repeat after:bg-center after:bg-contain">To & From</span> The Mainland</h2>
        <div class="grid lg:grid-cols-2 gap-5 lg:gap-8 lg:items-center">
            <div class="lg:pr-20">
                <h3 class="mb-4 mt-5 lg:mt-8">Shipping A Car To Hawaii</h3>
                <div class="text-content">
                    <p>Coastal Auto Shipping provides car shipping to Hawaii from almost all mainland locations. Looking to drop off yourself? There are three ports on the mainland to choose from&nbsp;Tacoma,&nbsp;Oakland&nbsp;and&nbsp;Long Beach. Discounted rates will not apply if any vehicle surpasses the dimensions of 21&rsquo;8&Prime;Lx8&prime;Wx7&prime;H, or vehicles with built-in accommodations for cooking or sleeping. Only out of Tacoma dimensions must be under 21&rsquo;8&Prime;Lx8&prime;Wx6&prime;3&Prime;H.</p>
                    <p>Nationwide pickup can be accommodated to transport your car from any city of origin on the mainland (address pick-up), with options of enclosed auto shipping services if shipping a new, classic or luxury car. Mainland transport rates will depend on your vehicle&rsquo;s size and location.</p>
                </div>
            </div>
            <div x-data="{ 
                videoModalOpen: false, 
                videoLoaded: false,
                videoSrc: 'https://www.youtube-nocookie.com/embed/u8uSPlSH79Y?autoplay=1&rel=0&modestbranding=1&iv_load_policy=3',
                openVideo() {
                    this.videoModalOpen = true;
                    this.videoLoaded = false;
                },
                closeVideo() {
                    this.videoModalOpen = false;
                    this.videoLoaded = false;
                    this.$refs.videoFrame.src = '';
                    setTimeout(() => {
                        this.$refs.videoFrame.src = this.videoSrc;
                    }, 500);
                }
            }" class="relative">
            <div class="video group flex flex-col items-center justify-center aspect-[1.44] bg-blue-50 bg-video-placeholder bg-cover bg-center bg-no-repeat hover:cursor-pointer"
                 @click="openVideo()">
                <div class="flex items-center justify-center gap-5">
                    <div class="flex items-center gap-1.5 bg-blue-600 rounded-2xl px-5 py-3 group-hover:bg-orange-600 transition-all">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M18.75 9.9999C18.7505 10.2121 18.6961 10.4208 18.5921 10.6058C18.488 10.7907 18.3379 10.9456 18.1562 11.0554L6.9 17.9413C6.71022 18.0575 6.49287 18.121 6.27037 18.1251C6.04788 18.1292 5.82832 18.0738 5.63438 17.9647C5.44227 17.8573 5.28225 17.7007 5.17075 17.5109C5.05926 17.3212 5.00032 17.1051 5 16.8851V3.11475C5.00032 2.89466 5.05926 2.67862 5.17075 2.48886C5.28225 2.2991 5.44227 2.14247 5.63438 2.03506C5.82832 1.92596 6.04788 1.87061 6.27037 1.87473C6.49287 1.87885 6.71022 1.94229 6.9 2.0585L18.1562 8.94443C18.3379 9.05418 18.488 9.20906 18.5921 9.39401C18.6961 9.57896 18.7505 9.78769 18.75 9.9999Z" fill="white"/>
                        </svg>
                        <p class="font-semibold text-white">Play Video</p>
                    </div>
                </div>
            </div>
            <div x-show="videoModalOpen" 
                 x-transition:enter="ease-out duration-300"
                 x-transition:enter-start="opacity-0"
                 x-transition:enter-end="opacity-100"
                 x-transition:leave="ease-in duration-200"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0"
                 class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-75 backdrop-blur-sm"
                 @click="closeVideo()"
                 @keydown.escape.window="closeVideo()"
                 x-cloak>
                <div class="relative w-full max-w-4xl mx-4" @click.stop>
                    <button @click="closeVideo()" 
                            class="absolute -top-12 right-0 text-white hover:text-gray-300 z-10">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                    <div class="relative w-full pb-[56.25%] h-0 bg-black rounded-lg overflow-hidden">
                        <div x-show="!videoLoaded" class="absolute inset-0 flex items-center justify-center bg-gray-900">
                            <div class="text-white text-center">
                                <svg class="animate-spin h-8 w-8 mx-auto mb-2" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                <p class="text-sm">Loading video...</p>
                            </div>
                        </div>
                        <iframe x-show="videoModalOpen"
                                x-ref="videoFrame"
                                @load="videoLoaded = true"
                                class="absolute top-0 left-0 w-full h-full"
                                :src="videoSrc"
                                frameborder="0"
                                loading="lazy"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen>
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <div class="grid lg:grid-cols-2 gap-5 lg:gap-8 mt-9 lg:mt-20 lg:items-center">
            <div x-data="{ 
                videoModalOpen: false, 
                videoLoaded: false,
                videoSrc: 'https://www.youtube-nocookie.com/embed/QgiBJ7eL5gk?autoplay=1&rel=0&modestbranding=1&iv_load_policy=3',
                openVideo() {
                    this.videoModalOpen = true;
                    this.videoLoaded = false;
                },
                closeVideo() {
                    this.videoModalOpen = false;
                    this.videoLoaded = false;
                    this.$refs.videoFrame.src = '';
                    setTimeout(() => {
                        this.$refs.videoFrame.src = this.videoSrc;
                    }, 500);
                }
            }" class="relative order-2 lg:order-1">
            <div class="video group flex flex-col items-center justify-center aspect-[1.44] bg-blue-50 bg-video-placeholder bg-cover bg-center bg-no-repeat hover:cursor-pointer"
                 @click="openVideo()">
                <div class="flex items-center justify-center gap-5">
                    <div class="flex items-center gap-1.5 bg-blue-600 rounded-2xl px-5 py-3 group-hover:bg-orange-600 transition-all">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M18.75 9.9999C18.7505 10.2121 18.6961 10.4208 18.5921 10.6058C18.488 10.7907 18.3379 10.9456 18.1562 11.0554L6.9 17.9413C6.71022 18.0575 6.49287 18.121 6.27037 18.1251C6.04788 18.1292 5.82832 18.0738 5.63438 17.9647C5.44227 17.8573 5.28225 17.7007 5.17075 17.5109C5.05926 17.3212 5.00032 17.1051 5 16.8851V3.11475C5.00032 2.89466 5.05926 2.67862 5.17075 2.48886C5.28225 2.2991 5.44227 2.14247 5.63438 2.03506C5.82832 1.92596 6.04788 1.87061 6.27037 1.87473C6.49287 1.87885 6.71022 1.94229 6.9 2.0585L18.1562 8.94443C18.3379 9.05418 18.488 9.20906 18.5921 9.39401C18.6961 9.57896 18.7505 9.78769 18.75 9.9999Z" fill="white"/>
                        </svg>
                        <p class="font-semibold text-white">Play Video</p>
                    </div>
                </div>
            </div>
            <div x-show="videoModalOpen" 
                 x-transition:enter="ease-out duration-300"
                 x-transition:enter-start="opacity-0"
                 x-transition:enter-end="opacity-100"
                 x-transition:leave="ease-in duration-200"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0"
                 class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-75 backdrop-blur-sm"
                 @click="closeVideo()"
                 @keydown.escape.window="closeVideo()"
                 x-cloak>
                <div class="relative w-full max-w-4xl mx-4" @click.stop>
                    <button @click="closeVideo()" 
                            class="absolute -top-12 right-0 text-white hover:text-gray-300 z-10">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                    <div class="relative w-full pb-[56.25%] h-0 bg-black rounded-lg overflow-hidden">
                        <div x-show="!videoLoaded" class="absolute inset-0 flex items-center justify-center bg-gray-900">
                            <div class="text-white text-center">
                                <svg class="animate-spin h-8 w-8 mx-auto mb-2" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                <p class="text-sm">Loading video...</p>
                            </div>
                        </div>
                        <iframe x-show="videoModalOpen"
                                x-ref="videoFrame"
                                @load="videoLoaded = true"
                                class="absolute top-0 left-0 w-full h-full"
                                :src="videoSrc"
                                frameborder="0"
                                loading="lazy"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen>
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
            <div class="lg:pl-20 order-1 lg:order-2">
                <h3 class="mb-4 mt-5 lg:mt-8">Shipping A Car From Hawaii</h3>
                <div class="text-content">
                    <p>Coastal Auto Shipping provides&nbsp;car shipping from Hawaii&nbsp;to almost all mainland locations. Looking to drop off yourself? There are four ports in Hawaii to choose from&nbsp;Honolulu,&nbsp;Hilo&nbsp;,&nbsp;Kahului&nbsp;and&nbsp;Nawiliwili. Discounted rates will not apply if any vehicle surpasses the dimensions of 21&rsquo;8&Prime;Lx8&prime;Wx7&prime;H, or vehicles with built-in accommodations for cooking or sleeping.</p>
                    <p>Nationwide vehicle delivery can be accommodated to transport your car from any Port on the mainland but, unfortunately transport cannot be provided on the Hawaii Islands. Mainland transport rates will depend on your vehicle&rsquo;s size and the delivery location.</p>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/sections/services/hawaii/car-transport-mainland.blade.php ENDPATH**/ ?>