<section class="bg-oyster100 py-20 lg:py-40">
    <div class="container">
        <div class="events-upcoming">
            <h2 class="mb-7 lg:mb-10">Upcoming Events</h2>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php
                $upcoming_events = new WP_Query([
                    'post_type' => 'events',
                    'posts_per_page' => -1,
                    'orderby' => 'meta_value',
                    'order' => 'ASC',
                    'meta_query' => [
                    [
                        'key' => 'event_status',
                        'value' => 1,
                        'compare' => '='
                    ]
                    ]
                ]);
                ?>
                <?php if($upcoming_events->have_posts()): ?>
                    <?php while($upcoming_events->have_posts()): ?> <?php $upcoming_events->the_post() ?>
                    <div class="event-card">
                        <a href="<?php echo e(the_permalink()); ?>" class="group" title="<?php echo e(the_title()); ?>">
                            <div class="relative mb-5 overflow-hidden">
                                <?php if(has_post_thumbnail()): ?>
                                    <img src="<?php echo e(get_the_post_thumbnail_url(null, 'large')); ?>" alt="<?php echo e(get_the_title()); ?>" class="w-full md:h-[400px] lg:h-[540px] object-cover object-center group-hover:scale-105 transition-all" alt="Event Banner" title="<?php echo get_the_title(); ?>" loading="lazy">
                                <?php else: ?>
                                    <img src="<?= \Roots\asset('images/backgrounds/blog-placeholder.svg'); ?>" class="w-full md:h-[400px] lg:h-[540px] object-cover object-center group-hover:scale-105 transition-all" alt="Featured Image Placeholder" title="Featured Image for - <?php echo get_the_title(); ?>" loading="lazy">
                                <?php endif; ?>
                                <div class="absolute w-full bottom-0 left-0 p-6 backdrop-blur-md bg-[rgba(240,238,227,0.10)]">
                                    <p class="text-white text-lg"><?php echo get_field('event_date_and_time'); ?></p>
                                </div>
                            </div>
                            <div class="event-meta">
                            <h3 class="h4 line-clamp-2"><?php echo get_the_title(); ?></h3>
                            <?php if (get_field('event_venue')) : ?>
                                <p class="mt-4"><?php echo get_field('event_venue'); ?></p>
                            <?php endif; ?>
                            <span class="flex items-center justify-start gap-3 text-blue700 font-semibold mt-4 group-hover:text-red700 transition-all">
                                View Event
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M15.938 5V13.125C15.938 13.3736 15.8392 13.6121 15.6634 13.7879C15.4876 13.9637 15.2491 14.0625 15.0005 14.0625C14.7518 14.0625 14.5134 13.9637 14.3375 13.7879C14.1617 13.6121 14.063 13.3736 14.063 13.125V7.26562L5.66374 15.6633C5.48762 15.8394 5.24875 15.9383 4.99967 15.9383C4.7506 15.9383 4.51173 15.8394 4.33561 15.6633C4.15949 15.4872 4.06055 15.2483 4.06055 14.9992C4.06055 14.7501 4.15949 14.5113 4.33561 14.3352L12.7348 5.9375H6.87545C6.62681 5.9375 6.38836 5.83873 6.21254 5.66291C6.03673 5.4871 5.93795 5.24864 5.93795 5C5.93795 4.75136 6.03673 4.5129 6.21254 4.33709C6.38836 4.16127 6.62681 4.0625 6.87545 4.0625H15.0005C15.2491 4.0625 15.4876 4.16127 15.6634 4.33709C15.8392 4.5129 15.938 4.75136 15.938 5Z" fill="currentColor"/>
                                </svg>
                            </span>
                            </div>
                        </a>
                    </div>
                    <?php endwhile; ?> <?php wp_reset_postdata() ?> 
                <?php else: ?>
                    <div class="bg-white border-l-4 border-oyster500 text-oyster800 p-4" role="alert">
                        <p>No upcoming events. Please check back later.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="events-past mt-20 lg:mt-30">
            <h2 class="mb-7 lg:mb-10">Past Events</h2>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php
                $past_events = new WP_Query([
                    'post_type' => 'events',
                    'posts_per_page' => -1,
                    'meta_key' => 'event_date_and_time',
                    'orderby' => 'meta_value',
                    'order' => 'DESC',
                    'meta_query' => [
                    [
                        'key' => 'event_status',
                        'value' => 0,
                        'compare' => '='
                    ]
                    ]
                ]);
                ?>
                <?php if($past_events->have_posts()): ?>
                    <?php while($past_events->have_posts()): ?> <?php $past_events->the_post() ?>
                    <div class="event-card">
                        <a href="<?php echo e(the_permalink()); ?>" class="group" title="<?php echo e(the_title()); ?>">
                            <div class="relative mb-5 overflow-hidden">
                                <?php if(has_post_thumbnail()): ?>
                                    <img src="<?php echo e(get_the_post_thumbnail_url(null, 'large')); ?>" alt="<?php echo e(get_the_title()); ?>" class="w-full md:h-[400px] lg:h-[540px] object-cover object-center group-hover:scale-105 transition-all" alt="Event Banner" title="<?php echo get_the_title(); ?>" loading="lazy">
                                <?php else: ?>
                                    <img src="<?= \Roots\asset('images/backgrounds/blog-placeholder.svg'); ?>" class="w-full md:h-[400px] lg:h-[540px] object-cover object-center group-hover:scale-105 transition-all" alt="Featured Image Placeholder" title="Featured Image for - <?php echo get_the_title(); ?>" loading="lazy">
                                <?php endif; ?>
                                <div class="absolute w-full bottom-0 left-0 p-6 backdrop-blur-md bg-[rgba(240,238,227,0.10)]">
                                    <p class="text-white text-lg"><?php echo get_field('event_date_and_time'); ?></p>
                                </div>
                            </div>
                            <div class="event-meta">
                            <h3 class="h4 line-clamp-2"><?php echo get_the_title(); ?></h3>
                            <?php if (get_field('event_venue')) : ?>
                                <p class="mt-4"><?php echo get_field('event_venue'); ?></p>
                            <?php endif; ?>
                            <span class="flex items-center justify-start gap-3 text-blue700 font-semibold mt-4 group-hover:text-red700 transition-all">
                                View Event
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M15.938 5V13.125C15.938 13.3736 15.8392 13.6121 15.6634 13.7879C15.4876 13.9637 15.2491 14.0625 15.0005 14.0625C14.7518 14.0625 14.5134 13.9637 14.3375 13.7879C14.1617 13.6121 14.063 13.3736 14.063 13.125V7.26562L5.66374 15.6633C5.48762 15.8394 5.24875 15.9383 4.99967 15.9383C4.7506 15.9383 4.51173 15.8394 4.33561 15.6633C4.15949 15.4872 4.06055 15.2483 4.06055 14.9992C4.06055 14.7501 4.15949 14.5113 4.33561 14.3352L12.7348 5.9375H6.87545C6.62681 5.9375 6.38836 5.83873 6.21254 5.66291C6.03673 5.4871 5.93795 5.24864 5.93795 5C5.93795 4.75136 6.03673 4.5129 6.21254 4.33709C6.38836 4.16127 6.62681 4.0625 6.87545 4.0625H15.0005C15.2491 4.0625 15.4876 4.16127 15.6634 4.33709C15.8392 4.5129 15.938 4.75136 15.938 5Z" fill="currentColor"/>
                                </svg>
                            </span>
                            </div>
                        </a>
                    </div>
                    <?php endwhile; ?> <?php wp_reset_postdata() ?> 
                <?php else: ?>
                    <div class="bg-white border-l-4 border-oyster500 text-oyster800 p-4" role="alert">
                        <p>No past events found.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
          
    </div>
</section><?php /**PATH /Users/ihfaz/Sites/jacobsandjacobs/resources/views/sections/events/archive.blade.php ENDPATH**/ ?>