<section class="bg-oyster100 pb-20 lg:pb-40">
    <div class="container lg:max-w-[1040px]">
        <div class="relative">
            <?php if(has_post_thumbnail()): ?>
                <img src="<?php echo e(get_the_post_thumbnail_url(null, 'large')); ?>" alt="<?php echo e(get_the_title()); ?>" class="w-full h-[300px] md:h-[500px] object-cover object-center" alt="Featured Image" title="Featured Image for - <?php echo get_the_title(); ?>" loading="lazy">
            <?php else: ?>
                <img src="<?= \Roots\asset('images/backgrounds/blog-placeholder.svg'); ?>" class="w-full h-[300px] md:h-[500px] object-cover object-center" alt="Featured Image Placeholder" title="Featured Image for - <?php echo get_the_title(); ?>" loading="lazy">
            <?php endif; ?>
            <div class="bg-oyster100 md:absolute md:bottom-0 md:left-0 py-4 md:py-8 md:px-10 grid grid-cols-[56px_1fr] gap-4 items-center">
                <a href="<?php echo e(get_the_permalink(94)); ?>" class="font-semibold hover:text-red700 transition-all" title="Tom Jacobs">
                    <img src="<?= \Roots\asset('images/attorneys/tom-avatar.jpg'); ?>" class="block h-14 w-14 rounded-full overflow-hidden" alt="Photo of Tom Jacobs" title="Tom Jacobs" loading="lazy">
                </a>
                <div>
                    <p class="text-lg">Written by <a href="<?php echo e(get_the_permalink(94)); ?>" class="font-semibold hover:text-red700 transition-all" title="Tom Jacobs">Tom Jacobs</a></p>
                    <p class="text-oyster800">Attorney at Law</p>
                </div>
            </div>
        </div>
        <article class="main-content mt-12">
            <?php the_content(); ?>
        </article>
        <a href="/blog/" class="flex items-center justify-center gap-3 rounded-full px-5 py-3 border border-oyster400 text-lg text-blue700 font-semibold w-fit hover:bg-blue700 hover:text-white hover:border-blue700 transition-all mt-12" title="Call Us">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                <path d="M17.8132 10.4999C17.8132 10.7485 17.7145 10.987 17.5387 11.1628C17.3628 11.3386 17.1244 11.4374 16.8757 11.4374H5.39136L9.41636 15.4616C9.59248 15.6377 9.69143 15.8766 9.69143 16.1257C9.69143 16.3747 9.59248 16.6136 9.41636 16.7897C9.24024 16.9658 9.00137 17.0648 8.7523 17.0648C8.50323 17.0648 8.26436 16.9658 8.08824 16.7897L2.46324 11.1647C2.37584 11.0776 2.30649 10.9741 2.25917 10.8602C2.21186 10.7462 2.1875 10.624 2.1875 10.5006C2.1875 10.3773 2.21186 10.2551 2.25917 10.1411C2.30649 10.0272 2.37584 9.92368 2.46324 9.83659L8.08824 4.21159C8.17544 4.12438 8.27897 4.05521 8.39291 4.00801C8.50685 3.96081 8.62897 3.93652 8.7523 3.93652C8.87563 3.93652 8.99775 3.96081 9.11169 4.00801C9.22563 4.05521 9.32916 4.12438 9.41636 4.21159C9.50357 4.29879 9.57275 4.40232 9.61994 4.51626C9.66714 4.6302 9.69143 4.75232 9.69143 4.87565C9.69143 4.99898 9.66714 5.1211 9.61994 5.23504C9.57275 5.34898 9.50357 5.45251 9.41636 5.53971L5.39136 9.56237H16.8757C17.1244 9.56237 17.3628 9.66114 17.5387 9.83696C17.7145 10.0128 17.8132 10.2512 17.8132 10.4999Z" fill="currentColor"/>
            </svg>
            Back to Blog
        </a>
    </div>
</section><?php /**PATH /var/www/vhosts/jacobsandjacobs.net/httpdocs/resources/views/sections/single/content.blade.php ENDPATH**/ ?>