<!doctype html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="theme-color" content="#F0EEE3" media="(prefers-color-scheme: light)">
        <meta name="theme-color" content="#555247" media="(prefers-color-scheme: dark)">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Instrument+Sans:ital,wght@0,400..700;1,400..700&family=Libre+Caslon+Text:ital@0;1&display=swap" rel="stylesheet">
        
        <?php wp_head(); ?>
        <?php echo $__env->make('utils.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Google tag (gtag.js) --> 
        <script async src="https://www.googletagmanager.com/gtag/js?id=G-SEQQEJY279"></script> 
        <script> 
            window.dataLayer = window.dataLayer || []; 
            function gtag(){dataLayer.push(arguments);} 
            gtag('js', new Date()); 
            
            gtag('config', 'G-SEQQEJY279'); 
        </script>
        <!-- Google tag (gtag.js) -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=G-CKSTSS6SV3"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            
            gtag('config', 'G-CKSTSS6SV3');
        </script>
        <!-- Meta Pixel Code -->
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '1228570878131627');
        fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
        src=https://www.facebook.com/tr?id=1228570878131627&ev=PageView&noscript=1
        /></noscript>
        <!-- End Meta Pixel Code -->
    </head>

    <body <?php body_class('px-0 overflow-x-hidden'); ?>>
        <?php wp_body_open(); ?>
        <?php do_action('get_header'); ?>
        <div id="app">

            <?php echo $__env->make('sections.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->yieldContent('before-content'); ?>

            <div class="<?php echo e($containerInnerClasses); ?> <?php if (! empty(trim($__env->yieldContent('sidebar')))): ?> gap-6 lg:grid-cols-12 grid <?php endif; ?>">
                <main id="main" class="<?php if (! empty(trim($__env->yieldContent('sidebar')))): ?>lg:col-span-8 <?php endif; ?>">
                    <div>
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </main>

                <?php if (! empty(trim($__env->yieldContent('sidebar')))): ?>
                    <aside class="sidebar lg:col-span-4">
                        <?php echo $__env->yieldContent('sidebar'); ?>
                    </aside>
                <?php endif; ?>
            </div>

            <?php echo $__env->yieldContent('after-content'); ?>

            <?php echo $__env->make('sections.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <?php do_action('get_footer'); ?>
        <?php echo $__env->yieldPushContent('after-scripts'); ?>
        <?php wp_footer(); ?>
        <?php echo $__env->make('utils.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </body>
</html><?php /**PATH /home/jacobsandjacobs/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>