<section class="py-16 md:py-20 lg:py-52">
    <div class="container flex flex-col lg:flex-row lg:justify-between gap-9">
        <div class="lg:w-1/2 lg:pr-20">
            <p class="subheading mb-3">Our Advantages</p>
            <h2 class="heading lg:text-5xl mb-6 lg:mb-10">Why Choose Coastal Auto Shipping?</h2>
            <div class="space-y-5">
                <p>Keeping customers informed is a priority for Coastal Auto Shipping. This is why we utilize an advanced tracking system that ensures you always know exactly where your shipment is, taking much of the stress and confusion out of the shipping experience.</p>
                <p>Coastal Auto Shipping takes pride in offering competitive pricing without compromising on service quality. We provide transparent quotes with no hidden fees, ensuring you know exactly what to expect.</p>
                <p>Safety and peace of mind are paramount when shipping a vehicle. Coastal Auto Shipping offers comprehensive insurance coverage to protect your vehicle during transit. This ensures that in the unlikely event of damage, you are fully covered.</p>
                <p>For any additional question or concerns, or if you&rsquo;re ready to get a quote, please contact the Coastal Auto Shipping team.</p>
            </div>
        </div>
        <div class="lg:w-1/2">
            <p class="h3 text-center mb-5 sm:hidden">People Trust Our Reliability</p>
            <div class="grid grid-cols-2 gap-6 text-center items-center">
                <div class="flex items-center justify-center p-6 max-sm:h-[120px] h-[200px] border-2 border-blue-50 rounded-[32px]">
                    <picture>
                        <source srcset="<?= \Roots\asset('images/badges/fmcsa.webp'); ?>" type="image/webp">
                        <img src="<?= \Roots\asset('images/badges/fmcsa.png'); ?>" class="max-sm:max-h-10.5" alt="FMCSA Logo" title="FMCSA">
                    </picture>
                </div>
                <div class="flex items-center justify-center p-6 max-sm:h-[120px] h-[200px] border-2 border-blue-50 rounded-[32px]">
                    <picture>
                        <source srcset="<?= \Roots\asset('images/badges/authorize.webp'); ?>" type="image/webp">
                        <img src="<?= \Roots\asset('images/badges/authorize.png'); ?>" class="max-sm:max-h-16.5" alt="Authorize.net" title="Verified Merchant - Authorize.net">
                    </picture>
                </div>
                <div class="flex items-center justify-center p-6 max-sm:h-[120px] h-[200px] border-2 border-blue-50 rounded-[32px]">
                    <picture>
                        <source srcset="<?= \Roots\asset('images/badges/bbb.webp'); ?>" type="image/webp">
                        <img src="<?= \Roots\asset('images/badges/bbb.png'); ?>" class="max-sm:max-h-11.5" alt="BBB Logo" title="BBB Accredited Business">
                    </picture>
                </div>
                <div class="flex items-center justify-center p-6 max-sm:h-[120px] h-[200px] border-2 border-blue-50 rounded-[32px] max-sm:hidden">
                    <img src="<?= \Roots\asset('images/badges/reliability.svg'); ?>" alt="Reliability" title="People Trust Our Reliability">
                </div>
                <div class="flex items-center justify-center p-6 max-sm:h-[120px] h-[200px] border-2 border-blue-50 rounded-[32px]">
                    <picture>
                        <source srcset="<?= \Roots\asset('images/badges/yelp.webp'); ?>" type="image/webp">
                        <img src="<?= \Roots\asset('images/badges/yelp.png'); ?>" class="max-sm:max-h-11.5" alt="Yelp Logo" title="Yelp 5-Star Rating">
                    </picture>
                </div>
                <div class="flex items-center justify-center p-6 max-sm:h-[120px] h-[200px] border-2 border-blue-50 rounded-[32px] max-sm:col-span-2">
                    <picture>
                        <source srcset="<?= \Roots\asset('images/badges/google.webp'); ?>" type="image/webp">
                        <img src="<?= \Roots\asset('images/badges/google.png'); ?>" class="max-sm:max-h-14.5" alt="Google Logo" title="Google 5-Star Rating">
                    </picture>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/sections/homepage/why-choose.blade.php ENDPATH**/ ?>