<section class="pt-8 pb-20 lg:pt-28 lg:pb-40 bg-oyster100">
    <div class="container">
        <div class=""></div>
        <?php if(have_posts()): ?>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php while(have_posts()): ?> <?php the_post(); ?>
                <article class="post-card relative">
                    <a href="<?php echo e(get_permalink()); ?>" class="group">
                        <div class="relative rounded-2xl overflow-hidden">
                            <?php if(has_post_thumbnail()): ?>
                                <img src="<?php echo e(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>"  alt="<?php echo e(get_the_title()); ?> - Featured Image"  title="<?php echo e(get_the_title()); ?>"  class="h-[240px] sm:h-[280px] object-cover object-top md:object-center w-full group-hover:scale-105 transition-all" loading="lazy">
                            <?php else: ?>
                                <img src="<?= \Roots\asset('images/backgrounds/blog-placeholder.svg'); ?>" alt="Featured Image Placeholder" title="Featured Image for - <?php echo get_the_title(); ?>" class="h-[240px] sm:h-[280px] object-cover object-top md:object-center w-full group-hover:scale-105 transition-all" loading="lazy">
                            <?php endif; ?>
                            <div class="absolute bottom-0 left-0 flex justify-between text-white text-sm p-6 backdrop-blur-md w-full">
                                <div>
                                    <p class="font-semibold">Tom Jacobs</p>
                                    <p><?php echo get_the_date(); ?></p>
                                </div>
                                <?php $categories = get_the_category(); ?> <?php if(!empty($categories) && $categories[0]->name !== 'Uncategorized'): ?> <?php echo '<p class="font-semibold">' . $categories[0]->name . '</p>'; ?><?php endif; ?>
                            </div>
                        </div>
                        <div class="mt-5">
                            <h2 class="h4 group-hover:text-red700 line-clamp-2 transition-all"><?php echo get_the_title(); ?></h2>
                            <p class="flex items-center justify-start gap-3 mt-2 font-semibold text-blue700 transition-all">
                                Read Article
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M15.9375 5V13.125C15.9375 13.3736 15.8387 13.6121 15.6629 13.7879C15.4871 13.9637 15.2486 14.0625 15 14.0625C14.7514 14.0625 14.5129 13.9637 14.3371 13.7879C14.1613 13.6121 14.0625 13.3736 14.0625 13.125V7.26562L5.66328 15.6633C5.48716 15.8394 5.24829 15.9383 4.99922 15.9383C4.75014 15.9383 4.51127 15.8394 4.33515 15.6633C4.15903 15.4872 4.06009 15.2483 4.06009 14.9992C4.06009 14.7501 4.15903 14.5113 4.33515 14.3352L12.7344 5.9375H6.875C6.62636 5.9375 6.3879 5.83873 6.21208 5.66291C6.03627 5.4871 5.9375 5.24864 5.9375 5C5.9375 4.75136 6.03627 4.5129 6.21208 4.33709C6.3879 4.16127 6.62636 4.0625 6.875 4.0625H15C15.2486 4.0625 15.4871 4.16127 15.6629 4.33709C15.8387 4.5129 15.9375 4.75136 15.9375 5Z" fill="#0F467C"/>
                                </svg>
                            </p>
                        </div>                        
                    </a>
                </article>
                <?php endwhile; ?>
            </div>
        <?php endif; ?>
        <div class="mb-5 mt-8 lg:mt-20 h-0.25 bg-oyster300"></div>
        <?php \App\otm_pagination() ?>
    </div>
</section><?php /**PATH /Users/ihfaz/Sites/jacobsandjacobs/resources/views/partials/post-card.blade.php ENDPATH**/ ?>