<?php
$element = $attributes->get('element', 'a');
if ($element === 'a' && !$attributes->has('href')) {
    $element = 'button';
}

$defaultClasses = 'block w-fit font-onest transition-all duration-300 rounded-[50px] text-center';

$types = [
    'primary' => 'primary-btn bg-blue700 text-white hover:bg-blue600 px-8 py-4 font-semibold',
    'primary-light' => 'bg-[#4169B0] text-white hover:bg-[#1B355D] px-8 py-4 font-semibold',
    'outline' => 'bg-white border border-[#1B355D] text-[#1B355D] hover:bg-[#1B355D] hover:text-white px-8 py-4 font-semibold',
    'outline-arrow' => 'bg-white border border-[#1B355D] text-[#1B355D] hover:bg-[#1B355D] hover:text-white px-6 py-3 font-semibold inline-flex items-center gap-2',
    'solid-arrow' => 'bg-[#1B355D] text-white hover:bg-[#4169B0] px-6 py-3 font-semibold inline-flex items-center gap-2',
];

$width = $attributes->get('fullWidth') ? 'w-full' : 'w-fit';
?>

<<?php echo e($element); ?>

    <?php echo e($attributes->merge(['class' => "{$defaultClasses} {$types[$attributes->get('type', 'primary')]} {$width}"])); ?>

>
    <?php echo e($slot); ?>

    <?php if(str_contains($attributes->get('type', ''), 'arrow')): ?>
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M5 12h14"/>
            <path d="m12 5 7 7-7 7"/>
        </svg>
    <?php endif; ?>
</<?php echo e($element); ?>><?php /**PATH /home/jacobsandjacobs/public_html/resources/views/components/button.blade.php ENDPATH**/ ?>