<?php
    $bg_class = is_home() ? 'bg-blog' : 'max-sm:bg-inner-sm bg-inner';
?>
<section class="<?php echo e($bg_class); ?> inner-hero relative [background-color:#100E0A] bg-no-repeat bg-center bg-cover after:absolute after:content-[''] after:w-full after:h-full after:inset-0 after:bg-[linear-gradient(180deg,_#3B2C1B_-108.12%,_rgba(59,44,27,0.64)_9.34%,_rgba(59,44,27,0.40)_173.5%)] after:z-0 after:pointer-events-none" <?php if(has_post_thumbnail() && !is_home()): ?> style="background-image: url('<?php echo e(get_the_post_thumbnail_url()); ?>')" <?php endif; ?>>
    <div class="relative container z-10 max-lg:hidden">
        <?php echo $__env->make('partials.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="relative container text-center text-white aspect-[1440/500] flex flex-col justify-center z-[1] py-16">
        <div class="mx-auto max-w-[768px]">
            <?php if (get_field('preheading')) : ?>
                <p class="pre-head !text-white mt-4"><?php echo get_field('preheading'); ?></p>
            <?php endif; ?>
            <h1 class="mb-6"><?php echo $heading; ?></h1>
            <?php if (get_field('subtext')) : ?>
                <p class="font-medium text-lg"><?php if(is_home()): ?> <?php echo e('Our vision is to passionately protect the rights of the injured.'); ?> <?php else: ?> <?php echo get_field('subtext'); ?> <?php endif; ?></p>
            <?php endif; ?>
            <?php if(is_home()): ?>
                <p class="font-medium text-lg">Our vision is to passionately protect the rights of the injured.</p>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php if(function_exists('rank_math_the_breadcrumbs')): ?>
    <div class="bg-oyster100 pt-5 lg:pt-8">
        <div class="container">
            <?php rank_math_the_breadcrumbs(); ?>
        </div>
    </div>
<?php endif; ?><?php /**PATH /var/www/vhosts/jacobsandjacobs.net/httpdocs/resources/views/sections/innerpage-hero.blade.php ENDPATH**/ ?>