<section class="py-16 md:py-20 lg:py-52">
    <div class="container max-w-[952px] text-center">
        <p class="subheading mb-3">What We Offer</p>
        <h2 class="mb-6 lg:mb-9 lg:text-5xl !leading-130">Preparing Your Vehicle for Shipment to the Delivery Location</h2>
        <p>Before shipping your car to or from Hawaii, ensure it is thoroughly inspected and complies with regulations regarding personal items and gas tank levels.</p>
    </div>
    <div class="container grid lg:grid-cols-2 gap-3 lg:gap-8 mt-9 lg:mt-14">
        <div class="p-6 lg:p-10 bg-white border-2 border-blue-50 rounded-[32px]">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                <path d="M15.75 10.4998C15.75 11.5381 15.4421 12.5532 14.8652 13.4165C14.2884 14.2799 13.4684 14.9528 12.5091 15.3501C11.5498 15.7475 10.4942 15.8515 9.47581 15.6489C8.45741 15.4463 7.52194 14.9463 6.78772 14.2121C6.05349 13.4779 5.55348 12.5424 5.35091 11.524C5.14833 10.5056 5.2523 9.45 5.64966 8.49068C6.04702 7.53137 6.71993 6.71143 7.58329 6.13456C8.44664 5.55768 9.46168 5.24977 10.5 5.24977C11.8924 5.24977 13.2278 5.8029 14.2123 6.78746C15.1969 7.77203 15.75 9.10739 15.75 10.4998ZM21.5307 21.5304C21.461 21.6001 21.3783 21.6554 21.2872 21.6932C21.1962 21.7309 21.0986 21.7504 21 21.7504C20.9015 21.7504 20.8039 21.7309 20.7128 21.6932C20.6218 21.6554 20.5391 21.6001 20.4694 21.5304L15.7763 16.8363C14.1442 18.1941 12.0515 18.8705 9.93346 18.7247C7.81543 18.5789 5.83514 17.6222 4.40449 16.0536C2.97384 14.485 2.20297 12.4252 2.25222 10.3027C2.30148 8.18027 3.16707 6.15849 4.66895 4.65793C6.17083 3.15738 8.19337 2.29358 10.3159 2.2462C12.4384 2.19882 14.4975 2.97151 16.0648 4.40354C17.6322 5.83558 18.5871 7.81672 18.731 9.93488C18.8749 12.053 18.1968 14.1451 16.8375 15.776L21.5307 20.4691C21.6004 20.5388 21.6557 20.6215 21.6934 20.7126C21.7312 20.8036 21.7506 20.9012 21.7506 20.9998C21.7506 21.0983 21.7312 21.1959 21.6934 21.287C21.6557 21.378 21.6004 21.4607 21.5307 21.5304ZM10.5 17.2498C11.8351 17.2498 13.1401 16.8539 14.2501 16.1122C15.3602 15.3705 16.2253 14.3163 16.7362 13.0829C17.2471 11.8495 17.3808 10.4923 17.1203 9.18291C16.8599 7.87354 16.217 6.67081 15.273 5.7268C14.329 4.7828 13.1263 4.13992 11.8169 3.87947C10.5075 3.61902 9.15032 3.75269 7.91692 4.26359C6.68351 4.77448 5.62931 5.63964 4.88761 6.74967C4.14591 7.8597 3.75003 9.16475 3.75003 10.4998C3.75201 12.2894 4.46381 14.0051 5.72925 15.2706C6.99469 16.536 8.71043 17.2478 10.5 17.2498Z" fill="#DB7A43"/>
            </svg>
            <h3 class="h5 mb-4 mt-5 lg:mt-8">The Importance of Thorough Inspection</h3>
            <div class="text-content">
                <p>Conducting a thorough inspection prevents complications. Document the car&rsquo;s condition with photos and notes, covering dents, scratches, and any existing damage. Use this documentation for comparison upon delivery.</p>
                <p>Ensure critical systems like the emergency brake and lights are functional. For inoperable vehicles, notify the shipping company as different procedures might apply. Check fluid levels (oil, transmission, etc.) and ensure there are no leaks, which could incur additional charges or denial of shipment.</p>
                <p>Remove any personal items, including infant car seats, to avoid misplacement or damage. Ensure you have the title or ownership document ready for verification. Also, record the license plate number for identification.</p>
            </div>
        </div>
        <div class="p-6 lg:p-10 bg-white border-2 border-blue-50 rounded-[32px]">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                <path d="M20.7 15.9C20.5702 15.8026 20.4123 15.75 20.25 15.75H19.5V6C19.5 5.20435 19.1839 4.44129 18.6213 3.87868C18.0587 3.31607 17.2956 3 16.5 3H3.75C2.95435 3 2.19129 3.31607 1.62868 3.87868C1.06607 4.44129 0.75 5.20435 0.75 6C0.75 7.27594 1.69219 8.01938 1.8 8.1C1.92947 8.19804 2.0876 8.25076 2.25 8.25C2.40631 8.24957 2.55858 8.20032 2.68553 8.10912C2.81248 8.01792 2.90776 7.88933 2.95806 7.74133C3.00836 7.59333 3.01115 7.43332 2.96606 7.28365C2.92097 7.13398 2.83025 7.00215 2.70656 6.90656C2.70281 6.90187 2.25 6.53813 2.25 6C2.25 5.60218 2.40804 5.22064 2.68934 4.93934C2.97064 4.65804 3.35218 4.5 3.75 4.5C4.14782 4.5 4.52936 4.65804 4.81066 4.93934C5.09196 5.22064 5.25 5.60218 5.25 6V18C5.25 18.7956 5.56607 19.5587 6.12868 20.1213C6.69129 20.6839 7.45435 21 8.25 21H18.75C19.5456 21 20.3087 20.6839 20.8713 20.1213C21.4339 19.5587 21.75 18.7956 21.75 18C21.75 16.7241 20.8125 15.9806 20.7 15.9ZM9.75 9H15.75C15.9489 9 16.1397 9.07902 16.2803 9.21967C16.421 9.36032 16.5 9.55109 16.5 9.75C16.5 9.94891 16.421 10.1397 16.2803 10.2803C16.1397 10.421 15.9489 10.5 15.75 10.5H9.75C9.55109 10.5 9.36032 10.421 9.21967 10.2803C9.07902 10.1397 9 9.94891 9 9.75C9 9.55109 9.07902 9.36032 9.21967 9.21967C9.36032 9.07902 9.55109 9 9.75 9ZM9 12.75C9 12.5511 9.07902 12.3603 9.21967 12.2197C9.36032 12.079 9.55109 12 9.75 12H15.75C15.9489 12 16.1397 12.079 16.2803 12.2197C16.421 12.3603 16.5 12.5511 16.5 12.75C16.5 12.9489 16.421 13.1397 16.2803 13.2803C16.1397 13.421 15.9489 13.5 15.75 13.5H9.75C9.55109 13.5 9.36032 13.421 9.21967 13.2803C9.07902 13.1397 9 12.9489 9 12.75ZM18.75 19.5H10.0978C10.362 19.0443 10.5007 18.5267 10.5 18C10.5002 17.7457 10.4619 17.4929 10.3866 17.25H19.9491C20.1353 17.4565 20.2425 17.7221 20.2519 18C20.2519 18.1971 20.213 18.3923 20.1375 18.5745C20.062 18.7566 19.9514 18.922 19.8119 19.0613C19.6724 19.2006 19.5068 19.3111 19.3246 19.3864C19.1424 19.4616 18.9471 19.5002 18.75 19.5Z" fill="#DB7A43"/>
            </svg>
            <h3 class="h5 mb-4 mt-5 lg:mt-8">Regulations on Personal Items and Gas Tank Levels</h3>
            <div class="text-content">
                <p>Shipping companies have strict rules on personal items within the vehicle. We do not allow any personal belongings because they are not insured during transit. If the car has to leave the mainland with personal items, verify with the carrier and note any specific restrictions.</p>
                <p>The gas tank should be filled to a quarter or one-eighth capacity to reduce weight and risks associated with fuel transport. This also reduces the shipper&rsquo;s liability in fuel-related issues. Make sure the tank is not completely empty, as the car will need enough fuel for minor repositioning.</p>
                <p>Adhering to these guidelines ensures a smoother shipment process and vehicle safety.</p>
            </div>
        </div>
    </div>
</section><?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/sections/services/hawaii-car/preparing-vehicle.blade.php ENDPATH**/ ?>